<?php

namespace Modules\Flights\Tests\Unit;

use Tests\TestCase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Log;
use Faker\Factory as Faker;

class FlightsControllerTest extends TestCase
{
    public $session_key;
    public $search_data;

    public function testAutoComplete()
    {
        $q = 'cairo';

        // Set up headers
        $headers = [
            'Authorization' => 'Bearer e2fe3b8b-9841-4692-96f6-ad0154e00cf5',
            'x-language-code' => 'en',
            'x-country-code' => 'us',
            'x-currency-code' => 'usd',
            'X-Client-Ip' => '127.0.0.1',
        ];

        // Generate the URL for the route
        $uri = action('Modules\Flights\Http\Controllers\FlightsController@auto_complete', ['q' => $q]);

        // Call the route directly with custom headers
        $response = $this->withHeaders($headers)->get($uri);

        // Assert the response structure and content
        $response->assertStatus(200)
            ->assertJsonStructure([
                'data' => [
                    '*' => [
                        'Type',
                        'Id',
                        'Code',
                        'Name',
                        'CityName',
                        'CountryName',
                    ],
                ],
            ]);
    }

    private function testSearch()
    {
        $headers = [
            'Authorization' => 'Bearer e2fe3b8b-9841-4692-96f6-ad0154e00cf5',
            'x-language-code' => 'en',
            'x-country-code' => 'us',
            'x-currency-code' => 'usd',
            'X-Client-Ip' => '127.0.0.1',
        ];

        $requestData = [
            'type' => 'onway',
            'legs' => [
                [
                    'departureCode' => 'CAI',
                    'arrivalCode' => 'dxb',
                    'outboundDate' => '2023-12-25',
                ]
            ],
            'adultsCount' => '1',
            'childrenCount' => '0',
            'infantsCount' => '0',
            'cabin' => 'ECONOMY',
            'airline' => 'MS',
            'currencyCode' => 'SAR',
            'locale' => 'en-SA',
        ];

        $request = $this->getMockBuilder(Request::class)
            ->disableOriginalConstructor()
            ->getMock();

        foreach ($requestData as $key => $value) {
            $request->$key = $value;
        }

        // Generate the URL for the route
        $uri = action('Modules\Flights\Http\Controllers\FlightsController@search');

        // Call the route directly with custom headers
        $response = $this->post($uri, $requestData, $headers);
        $this->session_key = $response;
        $responseData = json_decode($response->content(), true);
        $this->session_key = $responseData['sessions'][0];
        $this->search_data = $responseData['data'][0]['Options'][0];
        $this->assertEquals(200, $response->getStatusCode());
    }

    private function testSelectFlight()
    {
        // $this->testSearch();

        $headers = [
            'Authorization' => 'Bearer e2fe3b8b-9841-4692-96f6-ad0154e00cf5',
            'x-language-code' => 'en',
            'x-country-code' => 'us',
            'x-currency-code' => 'usd',
            'X-Client-Ip' => '127.0.0.1',
            'x-session' => $this->session_key
        ];

        $requestData = [
            'data' => $this->search_data
        ];
        // dd($requestData);
        $uri = action('Modules\Flights\Http\Controllers\FlightsController@select_flight');
        $selectFlightResponse = $this->post($uri, $requestData, $headers);
        $this->assertEquals(200, $selectFlightResponse->getStatusCode());
    }

    private function testPricing()
    {
        // $this->testSearch();
        // $this->testSelectFlight();

        $headers = [
            'Authorization' => 'Bearer e2fe3b8b-9841-4692-96f6-ad0154e00cf5',
            'x-language-code' => 'en',
            'x-country-code' => 'us',
            'x-currency-code' => 'usd',
            'X-Client-Ip' => '127.0.0.1',
            'x-session' => $this->session_key
        ];

        $requestData = [
            'data' => $this->search_data
        ];
        // dd($requestData);
        $uri = action('Modules\Flights\Http\Controllers\FlightsController@pricing');
        $selectFlightResponse = $this->post($uri, $requestData, $headers);
        $this->assertEquals(200, $selectFlightResponse->getStatusCode());
    }

    public function testBook()
    {
        $this->testSearch();
        dump($this->session_key);
        $this->testSelectFlight();
        dump($this->session_key);
        $this->testPricing();
        dump($this->session_key);

        $headers = [
            'Authorization' => 'Bearer e2fe3b8b-9841-4692-96f6-ad0154e00cf5',
            'x-language-code' => 'en',
            'x-country-code' => 'us',
            'x-currency-code' => 'usd',
            'X-Client-Ip' => '127.0.0.1',
            'x-session' => $this->session_key
        ];

        $faker = Faker::create();

        // Generate random data for travellers
        $travellers = [
            [
                'number' => 1,
                'type' => 'adult',
                'title' => "MR",
                'first_name' => $faker->firstName,
                'last_name' => $faker->lastName,
                'birthday' => [
                    'day' => $faker->dayOfMonth,
                    'month' => $faker->month,
                    'year' => $faker->dateTimeBetween('-80 years', '-18 years')->format('Y'),
                ],
                'email' => $faker->email,
                'mobile' => [
                    'code' => $faker->randomElement(['+20', '+91']),
                    'number' => $faker->numerify('##########'),
                    'full_number' => $faker->e164PhoneNumber,
                ],
                'mobile_country_code' => $faker->countryCode,
                'nationality' => $faker->country,
                'country_code' => $faker->countryCode,
                'city_name' => $faker->city,
                'city_code' => $faker->postcode,
                'address_line1' => $faker->streetAddress,
                'address_line2' => $faker->secondaryAddress,
                'idType' => $faker->randomElement(['NID', 'Passport']),
                'idNumber' => $faker->ean13,
                'idIssuer' => $faker->country,
                'idExpiry' => [
                    'day' => $faker->dayOfMonth,
                    'month' => $faker->month,
                    'year' => $faker->dateTimeBetween('now', '+10 years')->format('Y'),
                ],
            ],
        ];

        // Generate random data for ContactsData
        $contactsData = [
            'first_name' => $faker->firstName,
            'last_name' => $faker->lastName,
            'email' => $faker->email,
            'title' => "MR",
            'nationality' => 'eg',
            'mobile' => [
                'code' => $faker->randomElement(['+20', '+91']),
                'full_number' => $faker->e164PhoneNumber,
                'number' => $faker->numerify('##########'),
            ],
        ];

        $requestData = [
            'travellers' => $travellers,
            'ContactsData' => $contactsData,
        ];

        $uri = action('Modules\Flights\Http\Controllers\FlightsController@book');
        $bookFlightResponse = $this->post($uri, $requestData, $headers);
        $this->assertEquals(200, $bookFlightResponse->getStatusCode());
    }
}
