<?php

namespace Modules\Hotels\Http\Controllers;

use App\Models\CityCode;
use DOMDocument;
use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hotels\Http\Controllers\SDK\Tbo\TboSdkController;
use Modules\StaticData\Entities\City;
use Modules\StaticData\Entities\Country;
use SimpleXMLElement;
use Illuminate\Support\Str;
use Modules\Hotels\Entities\HotelsBookingList;
use Modules\StaticData\Entities\Hotel;

class TboController extends Controller
{
    protected $module_key;
    protected $supplier_key;
    protected $userName = '';
    protected $password = '';
    protected $companyCode = '';
    protected $settings = [];
    protected $tboholidays_sdk;
    protected $supplier_id;


    public function __construct(Request $request)
    {
        $this->module_key = 'hotels';
        $this->supplier_key = "tbo";
        $this->settings = $this->set_supplier_settings($request);
        $this->userName = $this->settings['Username'];
        $this->password = $this->settings['Password'];
        $this->tboholidays_sdk = new TboSdkController($this->settings);
        $this->supplier_id = get_supplier_id('tbo');
    }

    public function set_supplier_settings(Request $request)
    {
        $agent = $request->agent;
        return getSupplierSettings($this->module_key, $this->supplier_key, $agent);
    }
    //================================================ Search Hotels ============================
    public function getCurlFunc($input)
    {
        $curlHandle =  $this->tboholidays_sdk->hotelSearchCurlHandle($input);
        return $curlHandle;
    }

    public function prepareSearchResults($xmlResponse, $params)
    {
        $data = [];
        // $session_key = $data['SessionId'] = generate_session_key();
        try {
            //$myfile = "hotel_search_response.xml";
            //fwrite($myfile, $xmlResponse);
            //fclose($myfile);
            $data['TboCode'] = $params['cityCode'];
            $data['CityName'] = $params['cityName'];
            $doc = new DOMDocument('1.0', 'utf-8');
            $doc->loadXML($xmlResponse);
            $data['ResultStatus'] = $doc->getElementsByTagName("StatusCode")->item(0)->nodeValue;
            $data['StatusDescription'] = $doc->getElementsByTagName("Description")->item(0)->nodeValue;
            if ($data['ResultStatus'] == "01") {
                $session_key = $doc->getElementsByTagName("SessionId")->item(0)->nodeValue;
                $XMLresults = $doc->getElementsByTagName("HotelResult");
                $data['ResultNumber'] = $XMLresults->length;
                $hotels = [];
                $translation_hotels_limit = 2;
                foreach ($XMLresults as $resultKey => $XMLresult) {
                    $hotel['Supplier'] = 'tbo';
                    $hotel['SessionId'] = $session_key;
                    $hotel['ResultIndex'] = $XMLresult->getElementsByTagName("ResultIndex")->item(0)->nodeValue;
                    $hotel['TboCode'] = $XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("HotelCode")->item(0)->nodeValue;
                    $hotel['SupplierCode'] = $XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("HotelCode")->item(0)->nodeValue;
                    $hotel['Name'] = $XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("HotelName")->item(0)->nodeValue;
                    $hotelInfo = get_hotel_by_tbo_code($this->supplier_id, $hotel['TboCode']);
                    $hotel['Files'] = [];
                    if ($XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("HotelPicture")->length > 0) {
                        $hotel['Files'][] = $XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("HotelPicture")->item(0)->nodeValue;
                    }

                    if ($hotelInfo) {
                        $hotel['HotelWowCode'] = $hotel['TboCode'];
                        $hotel['CityWowCode'] = $hotelInfo->hotel_city->supplier_code[$this->supplier_id];
                        $hotel['SupplierKey'] = $this->supplier_key;
                        $hotel['Name'] = $hotelInfo->translate($params['langCode'])->name;
                        $hotel['Address'] = $hotelInfo->translate($params['langCode'])->address;
                        $hotel['Desc'] = $hotelInfo->translate($params['langCode'])->description;
                        $hotel['facilities'] = $hotelInfo->facilities;
                        $files = $hotelInfo->gallery;
                        //TODO handle hotels local files 
                        // $hotel_files = $this->api->db
                        //     ->where('hid', $hotelInfo->hotel_id)
                        //     ->join('files', 'files.file_id = hotels_files.fid')
                        //     ->limit(3)
                        //     ->get('hotels_files')
                        //     ->result();

                        // foreach ($hotel_files as $file) {
                        //     $files[] = base_url() . $file->file_path . '/' . $file->file_name;
                        // }

                        // if (count($files))
                        $hotel['Files'] = $files;
                    } else {
                        //TODO Import from tbo
                        // that hotels isn't in our db, proceed with the import from tbo
                        // $import = TRUE;
                        // $hotel_translate = ($resultKey) < $translation_hotels_limit;
                        // $hotel_details_response = $this->tboholidays_sdk->getHotelDetails($hotel['TboCode'], $data['CityTboCode'], $import, $hotel_translate);
                    }

                    $map = [];
                    //$hotel['HotelLatitude'] = "";
                    if ($XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("Latitude")->length > 0) {
                        $map['Lat'] = $XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("Latitude")->item(0)->nodeValue;
                    }

                    //hotel['HotelLongitude'] = "";
                    if ($XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("Longitude")->length > 0) {
                        $map['Long'] = $XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("Longitude")->item(0)->nodeValue;
                    }
                    $hotel['Map'] = $map;
                    $hotel['Rating'] = "";
                    if ($XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("Rating")->length > 0) {
                        $hotel['Rating'] = $XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("Rating")->item(0)->nodeValue;
                    }
                    if ($XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("HotelPromotion")->length > 0) {
                        $hotel_promotion = $XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("HotelPromotion")->item(0)->nodeValue;
                    }

                    $hotel['TripAdvisorRating'] = "";
                    if ($XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("TripAdvisorRating")->length > 0) {
                        $tripadvisor_rating = $XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("TripAdvisorRating")->item(0)->nodeValue;
                    }
                    if ($XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("TripAdvisorReviewURL")->length > 0) {
                        $tripadvisor_review_url = $XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("TripAdvisorReviewURL")->item(0)->nodeValue;
                    }
                    if ($XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("TagIds")->length > 0) {
                        $tag_ids = $XMLresult->getElementsByTagName("HotelInfo")->item(0)->getElementsByTagName("TagIds")->item(0)->nodeValue;
                    }
                    $price = $XMLresult->getElementsByTagName("MinHotelPrice")->item(0)->getAttribute('PrefPrice');
                    // $price = $this->add_markup($price); //TODO add markup
                    $hotel['Price'] = $price;
                    $hotel['Currency'] = $XMLresult->getElementsByTagName("MinHotelPrice")->item(0)->getAttribute('PrefCurrency');
                    $is_pkg_property = "";
                    if ($XMLresult->getElementsByTagName("IsPkgProperty")->length > 0) {
                        $is_pkg_property = $XMLresult->getElementsByTagName("IsPkgProperty")->item(0)->nodeValue;
                        $hotel['is_pkg_property'] = $is_pkg_property;
                    }
                    $is_pkg_rate = "";
                    if ($XMLresult->getElementsByTagName("IsPackageRate")->length > 0) {
                        $is_pkg_rate = $XMLresult->getElementsByTagName("IsPackageRate")->item(0)->nodeValue;
                        $hotel['is_pkg_rate'] = $is_pkg_rate;
                    }
                    $mapped_hotel = "";
                    if ($XMLresult->getElementsByTagName("MappedHotel")->length > 0) {
                        $mapped_hotel = $XMLresult->getElementsByTagName("MappedHotel")->item(0)->nodeValue;
                        $hotel['mapped_hotel'] = $mapped_hotel;
                    }
                    $first_room_type_name = "";
                    if ($XMLresult->getElementsByTagName("RoomDetails")->length > 0) {
                        if ($XMLresult->getElementsByTagName("RoomDetails")->item(0)->getElementsByTagName("Room")->length > 0) {
                            $first_room_type_name = $XMLresult->getElementsByTagName("RoomDetails")->item(0)->getElementsByTagName("Room")->item(0)->getAttribute('RoomType');
                            $hotel['first_room_type_name'] = $first_room_type_name;
                        }
                    }
                    $first_room_inclusion = "";
                    if ($XMLresult->getElementsByTagName("RoomDetails")->length > 0) {
                        if ($XMLresult->getElementsByTagName("RoomDetails")->item(0)->getElementsByTagName("Room")->length > 0) {
                            $first_room_inclusion = $XMLresult->getElementsByTagName("RoomDetails")->item(0)->getElementsByTagName("Room")->item(0)->getAttribute('Inclusion');
                            $hotel['first_room_inclusion'] = $first_room_inclusion;
                        }
                    }
                    $hotel['Supplier'] = [
                        'Name'      =>  'tbo',
                        'Session'   =>  $session_key,
                        'Code'      =>  $hotel['TboCode']
                    ];
                    $hotel['Info'] = [
                        'ResultIndex'   =>  $XMLresult->getElementsByTagName("ResultIndex")->item(0)->nodeValue,
                        'Name'          =>  $hotel['Name'],
                        'Address'       =>  $hotel['Address'],
                        'Desc'          =>  $hotel['Desc'],
                        'Map'           =>  $map,
                        'Files'         =>  $files,
                        'Code'          => $hotel['TboCode'] . ".{$this->supplier_id}"
                    ];
                    $hotel['Finance'] = [
                        'Price'         =>  $price,
                        'Currency'      =>  $XMLresult->getElementsByTagName("MinHotelPrice")->item(0)->getAttribute('PrefCurrency')
                    ];

                    array_push($hotels, $hotel);
                }
                // $data['Hotels'] = $hotels;

                return [
                    "status" => $hotels ? TRUE : false,
                    "message" => $doc->getElementsByTagName("Description")->item(0)->nodeValue,
                    "session_key"    => $session_key,
                    "supplier_key"    => $this->supplier_key,
                    "data"    => $hotels ?? []
                ];
            } else {
                $data['ResultNumber'] = 0;
                return [
                    "status" => $doc->getElementsByTagName("StatusCode")->item(0)->nodeValue,
                    "message" => $doc->getElementsByTagName("Description")->item(0)->nodeValue,
                    "data"    => $data
                ];
            }
        } catch (Exception $e) {
        }
    }
    //============================================ Available Rooms =================================
    public function available_rooms($session)
    {
        $session_key = $session['session_key'];
        $params['hotelCode'] = $session['hotel_id'];
        $params['Checkout'] = $session['query']['Checkout'];
        $params['Checkin'] = $session['query']['Checkin'];
        $params['Rooms'] = $session['query']['Rooms'];
        $params['sessionId'] = $session_key;
        $params['resultIndex'] = $session['result_index'];
        $xmlResponse = $this->tboholidays_sdk->availableRooms($params);
        $file_name = 'available_rooms_response.xml';
        //save_to_file($file_name, 'hotels', 'tbo', $xmlResponse);
        $doc = new DOMDocument('1.0', 'utf-8');
        $doc->loadXML($xmlResponse);

        $data['RoomsResultStatus'] = $doc->getElementsByTagName("StatusCode")->item(0)->nodeValue;
        if ($data['RoomsResultStatus'] == "01") {
            $data['HotelResultIndex'] = $doc->getElementsByTagName("ResultIndex")->item(0)->nodeValue;
            $XMLresults = $doc->getElementsByTagName("HotelRoom");
            $data['ResultNumber'] = $XMLresults->length;
            $data['OptionsForBookingFixedFormat'] = $doc->getElementsByTagName("FixedFormat")->item(0)->nodeValue;

            $roomCombs = $doc->getElementsByTagName("RoomCombination");
            // $comb_limit = 0;
            // $possibleCombs = [];
            // foreach( $roomCombs as $roomComb )
            // {
            //     $comb_limit++;
            //     $roomIndeciesString = "";
            //     $roomIndecies = $roomComb->getElementsByTagName("RoomIndex");
            //     /**
            //      * read Possible room combinations and build blocks of rooms from it
            //      */
            //     foreach( $roomIndecies as $roomIndex )
            //     {
            //         $roomIndeciesString .= $roomIndex->nodeValue . ",";
            //     }

            //     array_push($possibleCombs,$roomIndeciesString);

            //     /**
            //      * ! this is set manually to 10 and can be increased but will increase the response size
            //      */
            //     if ($comb_limit == 10)
            //     {
            //         break;
            //     }
            // }
            // $data['PossibleCombs'] = $possibleCombs;

            $rooms = [];
            foreach ($XMLresults as $XMLresult) {
                $room['RoomResultIndex'] = $XMLresult->getElementsByTagName("RoomIndex")->item(0)->nodeValue;
                $room['RoomTypeName'] = $XMLresult->getElementsByTagName("RoomTypeName")->item(0)->nodeValue;
                $room['RoomInclusion'] = $XMLresult->getElementsByTagName("Inclusion")->item(0)->nodeValue;
                $room['RoomTypeCode'] = $XMLresult->getElementsByTagName("RoomTypeCode")->item(0)->nodeValue;
                $room['RoomRatePlanCode'] = $XMLresult->getElementsByTagName("RatePlanCode")->item(0)->nodeValue;
                $room['RoomIsPackageRate'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getAttribute("IsPackageRate");
                // $room['RoomB2CRates'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getAttribute("B2CRates");
                $room['RoomAgentMarkUp'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getAttribute("AgentMarkUp");
                $room['RoomCurrency'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getAttribute("Currency");
                //$room['RoomPrice'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getAttribute("Price");
                $room['RoomFare'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getAttribute("RoomFare");
                $room['RoomTax'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getAttribute("RoomTax");
                $room['RoomTotalFare'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getAttribute("TotalFare");
                $room['RoomPrefPrice'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getAttribute("PrefPrice");
                $room['RoomPrefCurrency'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getAttribute("PrefCurrency");
                $dayRates = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getElementsByTagName("DayRates")->item(0)->getElementsByTagName("DayRate");
                $room['DayRates'] = array();
                foreach ($dayRates as $dayRate) {
                    $day['Date'] = $dayRate->getAttribute("Date");
                    $day['Fare'] = $dayRate->getAttribute("BaseFare");
                    array_push($room['DayRates'], $day);
                }
                $room['RoomExtraGuestCharges'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getElementsByTagName("ExtraGuestCharges")->item(0)->nodeValue;
                $room['RoomChildCharges'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getElementsByTagName("ChildCharges")->item(0)->nodeValue;
                $room['RoomDiscount'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getElementsByTagName("Discount")->item(0)->nodeValue;
                $room['RoomOtherCharges'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getElementsByTagName("OtherCharges")->item(0)->nodeValue;
                $room['RoomServiceTax'] = $XMLresult->getElementsByTagName("RoomRate")->item(0)->getElementsByTagName("ServiceTax")->item(0)->nodeValue;

                $roomPromtionNode = $XMLresult->getElementsByTagName("RoomPromtion")->item(0);
                if ($roomPromtionNode) {
                    $room['RoomPromtion'] = $roomPromtionNode->nodeValue;
                } else {
                    $room['RoomPromtion'] = null;
                }

                $room['RoomAmenities'] = $XMLresult->getElementsByTagName("Amenities")->item(0)->nodeValue;

                $room['RoomLastCancellationDeadline'] = $XMLresult->getElementsByTagName("CancelPolicies")->item(0)->getElementsByTagName("LastCancellationDeadline")->item(0)->nodeValue;
                $room['RoomDefaultPolicy'] = $XMLresult->getElementsByTagName("CancelPolicies")->item(0)->getElementsByTagName("DefaultPolicy")->item(0)->nodeValue;
                $cancelPolicies = $XMLresult->getElementsByTagName("CancelPolicies")->item(0)->getElementsByTagName("CancelPolicy");
                $room['CancelPolicies'] = [];

                foreach ($cancelPolicies as $cancelPolicy) {
                    $policy['FromDate'] = $cancelPolicy->getAttribute("FromDate");
                    $policy['ToDate'] = $cancelPolicy->getAttribute("ToDate");
                    $policy['ChargeType'] = $cancelPolicy->getAttribute("ChargeType");
                    $policy['CancellationCharge'] = $cancelPolicy->getAttribute("CancellationCharge");
                    $policy['Currency'] = $cancelPolicy->getAttribute("Currency");
                    $policy['PrefCurrency'] = $cancelPolicy->getAttribute("PrefCurrency");
                    $policy['PrefCancellationCharge'] = $cancelPolicy->getAttribute("PrefCancellationCharge");
                    array_push($room['CancelPolicies'], $policy);
                }

                if ($XMLresult->getElementsByTagName("Supplements")->length > 0) {
                    $supplements = $XMLresult->getElementsByTagName("Supplements")->item(0)->getElementsByTagName("Supplement");
                    $room['Supplements'] = array();
                    foreach ($supplements as $supplement) {
                        $supp['Type'] = $supplement->getAttribute("Type");
                        $supp['SuppID'] = $supplement->getAttribute("SuppID");
                        $supp['SuppName'] = $supplement->getAttribute("SuppName");
                        $supp['SuppIsMandatory'] = $supplement->getAttribute("SuppIsMandatory");
                        $supp['SuppChargeType'] = $supplement->getAttribute("SuppChargeType");
                        $supp['Price'] = $supplement->getAttribute("Price");
                        // $supp['Price'] = $supplement->getAttribute("CurrencyCode") == 'USD' ? $supplement->getAttribute("Price") : payment_currency($supplement->getAttribute("Price"), $supplement->getAttribute("CurrencyCode"), 'USD');
                        $supp['CurrencyCode'] = $supplement->getAttribute("CurrencyCode");
                        // $supp['CurrencyCode'] = 'USD';
                        array_push($room['Supplements'], $supp);
                    }
                }
                $rooms[$room['RoomResultIndex']] = $room;
            }

            $data['Rooms'] = $rooms;

            $data['Blocks'] = [];
            $number = 0;
            foreach ($roomCombs as $row) {
                $number++;
                $blocks = ['Rooms' => []];
                $total_price = 0;
                $currency = '';
                foreach ($row->getElementsByTagName("RoomIndex") as $block) {
                    $total_price += $data['Rooms'][$block->nodeValue]['RoomPrefPrice'];
                    $currency = $data['Rooms'][$block->nodeValue]['RoomPrefCurrency'];
                    $blocks['Rooms'][] = $data['Rooms'][$block->nodeValue] ?? [];
                }

                // $markup_price = $this->add_markup($total_price);
                $blocks['BlockPrefPrice'] = $total_price;
                $blocks['BlockPrefCurrency'] = $currency;

                $data['Blocks'][] = $blocks;
                if ($number == 10) {
                    break;
                }
            }

            $session_data['Hotel'] = $data;
            set_session('hotels', 'tbo', $session_key, null, $session_data);
            unset($data["Rooms"]);
            return $data;
        } else {
            throw new Exception($doc->getElementsByTagName("Description")->item(0)->nodeValue);
        }
    }

    //=========================================== Pricing ==========================================
    public function pricing($params)
    {
        $session_data = $params['session_data'];
        $data = [];
        $session_key = $params['session_key'];
        $room_block = $params['room_block'];
        $room_block_number = count($room_block);
        $hotel_result_index = $params['result_index'];
        $fixed_format = $session_data['Hotel']['OptionsForBookingFixedFormat'];
        // $hotel_info = ; //TODO get hotel info

        // $data['SupplierKey'] = $params['supplier_key'];
        // $data['HotelWowCode'] = $hotel_info->hotel_wow_code;
        // $data['CityWowCode'] = $hotel_info->hotel_city_wow_code;
        // $session_data = $this->api->wow_sessions->get_module_session("{$session_key}");
        // $session_data['hotel_tbo_code'] = $hotel_info->hotel_tbo_code;
        // $session_data['hotel_name_en'] = $hotel_info->hotel_name_en;


        $xmlResponse = $this->tboholidays_sdk->availablityPricing($session_key, $hotel_result_index, $fixed_format, $room_block);
        $file_name = "availability_and_pricing_response.xml";
        //save_to_file($file_name, 'hotels', 'tbo', $xmlResponse);
        $doc = new DOMDocument('1.0', 'utf-8');
        $doc->loadXML($xmlResponse);

        $data['ResultStatus'] = $doc->getElementsByTagName("StatusCode")->item(0)->nodeValue;
        if ($data['ResultStatus'] == "01") {
            $data['ResultIndex'] = $doc->getElementsByTagName("ResultIndex")->item(0)->nodeValue;
            $data['AvailableForBook'] = $doc->getElementsByTagName("AvailableForBook")->item(0)->nodeValue;
            $data['AvailableForConfirmBook'] = $doc->getElementsByTagName("AvailableForConfirmBook")->item(0)->nodeValue;

            $data['CancellationPoliciesAvailable'] = $doc->getElementsByTagName("CancellationPoliciesAvailable")->item(0)->nodeValue;
            if ($data['CancellationPoliciesAvailable'] != "false") {
                $hotelNorms = $doc->getElementsByTagName("HotelCancellationPolicies")->item(0)->getElementsByTagName("HotelNorms");
                $data['NormsString'] = "";
                foreach ($hotelNorms as $norm) {
                    foreach ($norm->getElementsByTagName("string") as $str) {
                        $data['NormsString'] .= $str->nodeValue . "\n";
                    }
                }
                $data['LastCancellationDeadline'] = $doc->getElementsByTagName("HotelCancellationPolicies")->item(0)->getElementsByTagName("CancelPolicies")->item(0)->getElementsByTagName("LastCancellationDeadline")->item(0)->nodeValue;
                $data['DefaultPolicy'] = $doc->getElementsByTagName("HotelCancellationPolicies")->item(0)->getElementsByTagName("CancelPolicies")->item(0)->getElementsByTagName("DefaultPolicy")->item(0)->nodeValue;
                $data['AutoCancellationText'] = $doc->getElementsByTagName("HotelCancellationPolicies")->item(0)->getElementsByTagName("CancelPolicies")->item(0)->getElementsByTagName("AutoCancellationText")->item(0)->nodeValue;

                $cancelPolicies = $doc->getElementsByTagName("HotelCancellationPolicies")->item(0)->getElementsByTagName("CancelPolicies")->item(0)->getElementsByTagName("CancelPolicy");
                $data['CancelPolicies'] = array();
                $confirmed_booking = false;
                foreach ($cancelPolicies as $cancelPolicy) {
                    $policy['FromDate'] = $cancelPolicy->getAttribute("FromDate");
                    $policy['ToDate'] = $cancelPolicy->getAttribute("ToDate");
                    $policy['ChargeType'] = $cancelPolicy->getAttribute("ChargeType");
                    $policy['CancellationCharge'] = $cancelPolicy->getAttribute("CancellationCharge");
                    $policy['Currency'] = $cancelPolicy->getAttribute("Currency");
                    $policy['PrefCurrency'] = $cancelPolicy->getAttribute("PrefCurrency");
                    if ($policy['ChargeType'] == "Fixed") {
                        $policy['PrefCancellationCharge'] = $cancelPolicy->getAttribute("PrefCancellationCharge");
                        if ((int) ($policy['PrefCancellationCharge']) == 0) {
                            $confirmed_booking = true;
                        }
                    }
                    array_push($data['CancelPolicies'], $policy);
                }
            }

            $data['PriceChanged'] = $doc->getElementsByTagName("PriceVerification")->item(0)->getAttribute("PriceChanged");
            $data['AvailableOnNewPrice'] = $doc->getElementsByTagName("PriceVerification")->item(0)->getAttribute("AvailableOnNewPrice");

            $data['AgencyBalance'] = $doc->getElementsByTagName("AccountInfo")->item(0)->getAttribute("AgencyBalance");
            $data['AgencyBlocked'] = $doc->getElementsByTagName("AccountInfo")->item(0)->getAttribute("AgencyBlocked");

            $data['HotelName'] = $doc->getElementsByTagName("HotelDetails")->item(0)->getAttribute("HotelName");
            $data['HotelRating'] = $doc->getElementsByTagName("HotelDetails")->item(0)->getAttribute("HotelRating");
            $data['HotelAddress'] = "";
            if ($doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("Address")->length > 0) {
                $data['HotelAddress'] = $doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("Address")->item(0)->nodeValue;
            }

            if ($doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("FaxNumber")->length > 0) {
                $data['HotelFaxNumber'] = $doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("FaxNumber")->item(0)->nodeValue;
            }
            if ($doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("PhoneNumber")->length > 0) {
                $data['HotelPhoneNumber'] = $doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("PhoneNumber")->item(0)->nodeValue;
            }
            $data['HotelMap']['Lat'] = "";
            $data['HotelMap']['Long'] = "";
            if ($doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("Map")->length > 0) {
                $hotel_map = $doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("Map")->item(0)->nodeValue;
                $hotel_map_array = explode('|', $hotel_map);
                if ($hotel_map[0]) {
                    $data['HotelMap']['Lat'] = $hotel_map_array[0];
                }
                if ($hotel_map[1]) {
                    $data['HotelMap']['Long'] = $hotel_map_array[1];
                }
            }

            $session_data['BookingInfo'] = [
                'HotelCode' => $params['hotel_id'],
                'HotelName' => $data['HotelName'],
                'AvailableForBook'  =>  $data['AvailableForBook'],
                'AvailableForConfirmBook' =>  $data['AvailableForConfirmBook'],
                'HotelAddress' => $data['HotelAddress']
            ];

            // if(!isset($wow_session['rooms_guests'])){
            //     throw new Exception("Session Expired");
            // }
            // $data['RoomsGuests'] = $session_data['rooms_guests'];

            // foreach ($data['RoomsGuests'] as $key => $row) {
            //     if (!isset($row['children_ages'])) {
            //         $data['RoomsGuests'][$key]['children_ages'] = [];
            //     }
            // }

            $response = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $xmlResponse);
            $xml = new SimpleXMLElement($response);
            $body = $xml->xpath('//sBody')[0];
            $array = json_decode(json_encode((array)$body), TRUE);
            $hotel_rooms = $array['AvailabilityAndPricingResponse']['HotelRooms']['HotelRoom'];
            $data['HotelRooms'] =  [];

            if ($room_block_number == 1) {
                $data['HotelRooms'][0] = $hotel_rooms;
            } else {
                $data['HotelRooms'] = $hotel_rooms;
            }
            $total_price = 0;
            foreach ($data['HotelRooms'] as $row) {
                $total_price += $row['RoomRate']['@attributes']['PrefPrice'];
            }
            //TODO add markup
            $data['TotalOriginalPrefPrice'] = $total_price;

            // $markup_price = $this->add_markup($total_price);
            // $markup_amount = $markup_price - $total_price;
            // $room_markup_amount = $markup_amount / count($data['HotelRooms']);

            $data['TotalPrefPrice'] = $total_price;
            $data['PrefCurrency'] = $row['RoomRate']['@attributes']['PrefCurrency'];
            $data['Rooms'] = [];

            foreach ($data['HotelRooms'] as $row) {
                $hotel_room = [
                    'RoomIndex' =>  $row['RoomIndex'],
                    'Amenities' =>  $row['Amenities'],
                    'Inclusion' =>  $row['Inclusion'],
                    'MealType' =>  $row['MealType'],
                    'RatePlanCode' =>  $row['RatePlanCode'],
                    'RoomPromtion'  =>  $row['RoomPromtion'],
                    'Supplements'  =>  isset($row['Supplements']) ? $row['Supplements'] : null,
                    'RoomTypeName'  =>  $row['RoomTypeName'],
                    'RoomTypeCode'  =>  $row['RoomTypeCode'],
                    'RoomRate'      =>  $row['RoomRate'],
                    'Rate'  =>  [
                        'PrefPrice' =>  $row['RoomRate']['@attributes']['PrefPrice'] /* + $room_markup_amount */,
                        'PrefCurrency' =>  $row['RoomRate']['@attributes']['PrefCurrency']
                    ],
                ];
                $data['Rooms'][] = $hotel_room;
            }
            // !TODO

            $session_data['Finance'] = [
                'OriginalAmount' =>  $data['TotalOriginalPrefPrice'],
                'Amount' =>  $total_price,
                'CurrencyCode'  =>  $data['PrefCurrency']
            ];
            $session_data['selected_rooms'] = $data['Rooms'];
            set_session('hotels', 'tbo', $session_key, null, $session_data);

            //if availableforbook = true && availableforconfirmbook = true 
            //then the client can pay later and we can make confirmed booking instead of vouchered booking
            if ($data['AvailableForBook'] == true && $data['AvailableForConfirmBook'] == true) {
                //confirmed booking can be made
            } else if ($data['AvailableForBook'] == "true" && $data['AvailableForConfirmBook'] == "false") {
                // vouchered booking can be made
            } else {
                //die("Booking Unavailable");
            }

            return $data;
        } else {
            throw new Exception($doc->getElementsByTagName("Description")->item(0)->nodeValue);
        }
    }
    //=========================================== Booking ===========================================
    public function pre_booking($input)
    {
        $session_key = $input['SupplierSessionId'];
        $session_data = $this->api->wow_sessions->get_module_session("{$session_key}");

        $hotel_wow_code = $input['HotelCode'];
        // $hotel_info = $this->get_hotel_by_tbo_code($hotel_tbo_code);
        $hotel_info = $this->api->db
            ->where('hotel_wow_code', $hotel_wow_code)
            ->get('hotel_list')->row();

        $data = [];
        if ($hotel_info) {
            $lang_prefix = '_' . $input['LangCode'];
            $data = [
                'HotelName' => $hotel_info->{"hotel_name{$lang_prefix}"},
                'HotelCountry' => $hotel_info->{"hotel_country_name{$lang_prefix}"},
                'HotelCity' => $hotel_info->{"hotel_city_name{$lang_prefix}"},
                'HotelAddress' => $hotel_info->{"hotel_address{$lang_prefix}"},
                'HotelRating' => $hotel_info->{"hotel_rating"},
                'RoomsGuests' => $session_data['rooms_guests'],
            ];
        }

        return $data;
    }

    public function booking($input)
    {
        $data = [];
        $lead_guest = $input['LeadGuest'];
        $rooms_guests = $input['RoomsGuests'];
        $user_credits = $input['agent']->balance;
        $session_data = $input['sessionData'];
        $session_key = $session_data['key'];
        $selected_rooms = $session_data['data']['selected_rooms'];
        $hotel_result_index = $session_data['data']['Hotel']['HotelResultIndex'];
        $hotel_code = $session_data['data']['BookingInfo']['HotelCode'];
        $supplierId = get_supplier_id($this->supplier_key);
        $hotel = Hotel::getHotelsBySupplierCode($supplierId, $hotel_code)->first();
        $hotel_name_en = $session_data['data']['BookingInfo']['HotelName'];
        $total_price = $session_data['data']['Finance']['Amount']; //TODO add markup
        $current_date = date("dmyHms") . "000";
        $random_string = Str::random(6);
        $client_reference_number = $current_date . "#" . $random_string;
        $nationality = $input['LeadGuest']['nationality'];

        // Check Payment
        $user_net_amount = $user_credits->credit_amount - $total_price;
        $available_for_pay = FALSE;

        if ($user_net_amount >= $user_credits->credit_allowed_amount) {
            $available_for_pay = TRUE;
        }

        if (!$available_for_pay) {
            throw new Exception('Booking erro ,' . __('api.Agent_not_allowed_to_pay_due_to_low_balance'));
        }

        $session_data['booking_needed_details'] = [
            'client_ref'    =>  $client_reference_number,
            'nationality'   =>  $nationality,
            'session_id'    =>  $session_key,
            'hotel_result_index'    =>  $hotel_result_index,
            'hotel_code'    =>  $hotel_code,
            'hotel_name_en' =>  $hotel_name_en,
            'selected_rooms'    =>  $selected_rooms,
            'lead_guest'    =>  $lead_guest,
            'rooms_guests'  =>  $rooms_guests
        ];

        $amount_to_pay = $total_price;

        // $amount_to_pay = payment_currency($amount_to_pay, $input['CurrencyCode'], 'USD');
        $amount_to_pay = $amount_to_pay;
        // $amount_to_pay = $this->add_markup($amount_to_pay);//TODO markup

        $booking_data = [];

        if ($session_data['data']['BookingInfo']['AvailableForBook'] === 'true' && $session_data['data']['BookingInfo']['AvailableForConfirmBook'] === 'true') {
            $bookParams = [
                'client_reference_number' => $client_reference_number,
                'nationality' => $nationality,
                'session_id' => $session_key,
                'hotel_result_index' => $hotel_result_index,
                'hotel_code' => $hotel_code,
                'hotel_name_en' => $hotel_name_en,
                'selected_rooms' => $selected_rooms,
                'lead_guest' => $lead_guest,
                'rooms_guests' => $rooms_guests,
            ];
            $bookingXmlResponse = $this->tboholidays_sdk->book($bookParams);
            $file_name = "hotel_book_respnose.xml";
            //save_to_file($file_name, 'hotels', 'tbo', $bookingXmlResponse);
            $doc = new DOMDocument('1.0', 'utf-8');
            $doc->loadXML($bookingXmlResponse);
            $status = $doc->getElementsByTagName("StatusCode")->item(0)->nodeValue;
            $message = $doc->getElementsByTagName("Description")->item(0)->nodeValue;
            if ($doc->getElementsByTagName("ConfirmationNo")->length > 0 && $status == '01') {
                $confirmation_number = $doc->getElementsByTagName("ConfirmationNo")->item(0)->nodeValue;
            } else {
                throw new Exception("Booking Error From Supplier , {$message}");
            }

            $data = $this->booking_details($client_reference_number)['data'];
            $data['confirmation_number'] = $confirmation_number;
            $booking_data = array(
                'customer_id'   =>  $input['UserId'],
                'company_id'    =>  $input['agent']->id,
                'supplier_id'  => $supplierId,
                'supplier_booking_id' => $data['BookingId'],
                'amendment_status' => $data['AmendmentStatus'],
                'confirmation_number' => $data['ConfirmationNo'],
                'invoice_number' => $data['InvoiceNumber'],
                'supplier_ref_number' => $data['SupplierReferenceNo'],
                'trip_name' => $data['TripName'],
                'requested_client_ref_number' => $client_reference_number,
                'booking_description' => $data['BookingDesc'],
                'booking_status' => $data['BookingStatus'],
                'voucher_status' => $data['VoucherStatus'],
                'payment_status' => 'pending',
                'payment_deadline' => null,
                // 'hotel_name' => $data['HotelName'],
                // 'hotel_rating' => $data['Rating'],
                'hotel_id'  =>  $hotel ? $hotel->id : null,
                // 'city_code' => $data['CityId'],
                // 'city_name' => $data['City'],
                'from_date' => $data['CheckInDate'],
                'to_date' => $data['CheckOutDate'],
                'last_cancellation_deadline' => $data['LastCancellationDeadline'],
                'current_cancellation_charge' => $data['CurrentCancellationCharges'],
                'rooms_number' => $data['NoOfRooms'],
                'rooms_type_name' => $data['roomsname'],
                'currency_code' => $data['Currency'],
                'original_amount'    =>  $session_data['data']['Finance']['OriginalAmount'],
                'amount' => $session_data['data']['Finance']['Amount'],
                'booking_date' => $data['BookingDate'],
                'booking_details'    =>  [
                    'booking_needed_details' => $session_data['booking_needed_details'],
                    'selected_rooms' => $session_data['data']['selected_rooms'],
                    'room_guests' => $rooms_guests
                ]
            );
        } elseif ($session_data['data']['BookingInfo']['AvailableForBook'] === 'true' && $session_data['data']['BookingInfo']['AvailableForConfirmBook'] === 'false') {

            $booking_data = array(
                'customer_id'   =>  $input['UserId'],
                'company_id'    =>  $input['Company']->id,
                'supplier_id'  => $supplierId,
                'requested_client_ref_number' => $client_reference_number,
                'booking_status' => 'false',
                'voucher_status' => 'pending',
                'payment_status' => 'pending',
                'payment_deadline' => null,
                // 'hotel_name' => $hotel_name_en,
                'hotel_id'  =>  $hotel->id,
                'from_date' => $session_data['Checkin'],
                'to_date' => $session_data['Checkout'],
                // 'currency_code' => $session_data['Finance']['CurrencyCode'],
                'currency_code' => 'USD',
                'original_amount'    =>  $session_data['Finance']['OriginalAmount'],
                'amount' => $session_data['Finance']['Amount'],
                'confirmation_number' =>    'false',
                'booking_details'    =>  [
                    'booking_needed_details' => $session_data['booking_needed_details'],
                    'selected_rooms' => $session_data['data']['selected_rooms'],
                    'room_guests' => $rooms_guests
                ]
            );
        }
        if (!$booking_data) {
            throw new Exception('Booking Error , No Booking Data');
        }

        $booking = HotelsBookingList::create($booking_data);
        $booking_id = $booking->id;

        //Payment prepare
        $short_merchant_ref = implode('.', [$booking_id, $input['UserId']]);
        // $data['MerchantRef'] = implode('.', ['hotels', 'tbo', $booking_id, $input['UserId']]);
        $data['MerchantRef'] = $short_merchant_ref;
        $data['UserId'] = $input['agent']->id;
        $data['amount_to_pay'] = $amount_to_pay;
        // transaction table

        // $payment = paymentTransaction::create(
        //     [
        //         'module'    =>  'hotels',
        //         'supplier_name' =>  'tbo',
        //         'merchant_ref'  => $data['MerchantRef'],
        //         'user_id'   =>  $input['agent']->id,
        //         'currency'  =>  $booking_data['currency_code'],
        //         'amount'    =>  $amount_to_pay,
        //         'status'    =>  'pending',
        //         'payment_option'    =>  'card' // todo change according to b2c or b2b
        //     ]
        // );
        $booking = HotelsBookingList::find($booking->id);
        $booking['supplier_name'] = 'tbo';
        return [
            'status'    =>  $data['MerchantRef'] ? TRUE : FALSE,
            'message'   =>  isset($data['BookingDesc']) ? $data['BookingDesc'] : 'Dummy booking created',
            'data' => [
                'bookingData' => $booking,
                'MerchantRef'   =>  $data['MerchantRef'],
            ]
        ];
    }

    public function booking_details($client_ref_number)
    {
        $xmlbookDetailResponse = $this->tboholidays_sdk->bookingDetails($client_ref_number);
        $file_name = "booking_details_respnose.xml";
        //save_to_file($file_name, 'hotels', 'tbo', $xmlbookDetailResponse);
        $detaildoc = new DOMDocument('1.0', 'utf-8');
        $detaildoc->loadXML($xmlbookDetailResponse);
        $data['ResultStatus'] = $detaildoc->getElementsByTagName("StatusCode")->item(0)->nodeValue;
        $data['BookingDesc'] = $detaildoc->getElementsByTagName("Description")->item(0)->nodeValue;
        $data['BookingId'] = "";
        $data['AmendmentStatus'] = "";
        $data['BookingStatus'] = "";
        $data['VoucherStatus'] = "";
        $data['InvoiceNumber'] = "";
        $data['SupplierReferenceNo'] = "";
        $data['ConfirmationNo'] = "";
        $data['Rating'] = "";
        $data['AddressLine1'] = "";
        $data['AddressLine2'] = "";
        $data['Lat'] = "";
        $data['Lng'] = "";
        $data['City'] = "";
        $data['CheckInDate'] = "";
        $data['CheckOutDate'] = "";
        $data['BookingDate'] = date("Y-m-d");
        $data['Currency'] = "";
        $data['NoOfRooms'] = "";
        $data['LastCancellationDeadline'] = "";
        $data['CityId'] = "";
        $data['TripName'] = "";
        $data['HotelTBOCode'] = "";
        $data['CurrentCancellationCharges'] = "";
        $roomsname = "";
        $totPrice = 0;
        $data['RoomsDetails'] = array();
        if ($data['ResultStatus'] == "01") {
            if ($detaildoc->getElementsByTagName("BookingDetail")->length > 0) {
                $data['BookingId'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getAttribute("BookingId");
                $data['AmendmentStatus'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getAttribute("AmendmentStatus");
                $data['BookingStatus'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getAttribute("BookingStatus");
                $data['VoucherStatus'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getAttribute("VoucherStatus");
                $data['InvoiceNumber'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getAttribute("InvoiceNumber");
                $data['SupplierReferenceNo'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getAttribute("SupplierReferenceNo");
                $data['ConfirmationNo'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getAttribute("ConfirmationNo");
                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("HotelName")->length > 0) {
                    $data['HotelName'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("HotelName")->item(0)->nodeValue;
                }

                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("Rating")->length > 0) {
                    $data['Rating'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("Rating")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("AddressLine1")->length > 0) {
                    $data['AddressLine1'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("AddressLine1")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("AddressLine2")->length > 0) {
                    $data['AddressLine2'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("AddressLine2")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("Map")->length > 0) {
                    $data['Map'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("Map")->item(0)->nodeValue;
                    $map = explode("|", $data['Map']);
                    $data['Lat'] = $map[0];
                    $data['Lng'] = $map[1];
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("City")->length > 0) {
                    $data['City'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("City")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("CheckInDate")->length > 0) {
                    $data['CheckInDate'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("CheckInDate")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("CheckOutDate")->length > 0) {
                    $data['CheckOutDate'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("CheckOutDate")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("BookingDate")->length > 0) {
                    $data['BookingDate'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("BookingDate")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("HotelCancelPolicies")->length > 0) {
                    $data['LastCancellationDeadline'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("HotelCancelPolicies")->item(0)->getElementsByTagName("LastCancellationDeadline")->item(0)->nodeValue;
                    $cancelPolicies = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("HotelCancelPolicies")->item(0)->getElementsByTagName("CancelPolicy");
                    $data['CancelPolicies'] = array();
                    foreach ($cancelPolicies as $cancelPolicy) {
                        $policy['RoomTypeName'] = $cancelPolicy->getAttribute("RoomTypeName");
                        $policy['RoomIndex'] = $cancelPolicy->getAttribute("RoomIndex");
                        $policy['FromDate'] = $cancelPolicy->getAttribute("FromDate");
                        $policy['ToDate'] = $cancelPolicy->getAttribute("ToDate");
                        $policy['ChargeType'] = $cancelPolicy->getAttribute("ChargeType");
                        $policy['CancellationCharge'] = $cancelPolicy->getAttribute("CancellationCharge");
                        $policy['Currency'] = $cancelPolicy->getAttribute("Currency");

                        array_push($data['CancelPolicies'], $policy);
                    }
                }

                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("HotelPolicyDetails")->length > 0) {
                    $data['HotelPolicyDetails'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("HotelPolicyDetails")->item(0)->nodeValue;
                }



                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("Currency")->length > 0) {
                    $data['Currency'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("Currency")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("NoOfRooms")->length > 0) {
                    $data['NoOfRooms'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("NoOfRooms")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("CityId")->length > 0) {
                    $data['CityId'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("CityId")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("TripName")->length > 0) {
                    $data['TripName'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("TripName")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("TBOHotelCode")->length > 0) {
                    $data['TBOHotelCode'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("TBOHotelCode")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("CurrentCancellationCharges")->length > 0) {
                    $data['CurrentCancellationCharges'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("CurrentCancellationCharges")->item(0)->nodeValue;
                }

                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("AgencyDetails")->length > 0) {
                    $data['AgencyName'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("AgencyDetails")->item(0)->getElementsByTagName("Name")->item(0)->nodeValue;
                    $data['AgencyAddressLine1'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("AgencyDetails")->item(0)->getElementsByTagName("AddressLine1")->item(0)->nodeValue;
                    $data['AgencyPhone'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("AgencyDetails")->item(0)->getElementsByTagName("Phone")->item(0)->nodeValue;
                    $data['AgencyCity'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("AgencyDetails")->item(0)->getElementsByTagName("City")->item(0)->nodeValue;
                    $data['AgencyBookingMemberName'] = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("AgencyDetails")->item(0)->getElementsByTagName("BookingMemberName")->item(0)->nodeValue;
                }


                if ($detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("Roomtype")->length > 0) {
                    $roomsDetails = $detaildoc->getElementsByTagName("BookingDetail")->item(0)->getElementsByTagName("Roomtype")->item(0)->getElementsByTagName("RoomDetails");
                    $data['RoomsDetails'] = array();

                    foreach ($roomsDetails as $roomDetails) {
                        $room['AdultCount'] = $roomDetails->getElementsByTagName("AdultCount")->item(0)->nodeValue;
                        $room['ChildCount'] = $roomDetails->getElementsByTagName("ChildCount")->item(0)->nodeValue;
                        $room['ChildAges'] = "";
                        if ($roomDetails->getElementsByTagName("ChildAge")->length > 0) {
                            $ChildAges = $roomDetails->getElementsByTagName("ChildAge");
                            foreach ($ChildAges as $ChildAge) {
                                $room['ChildAges'] .= $ChildAge->nodeValue . " , ";
                            }
                        }
                        $room['RoomName'] = $roomDetails->getElementsByTagName("RoomName")->item(0)->nodeValue;
                        $roomsname .= $room['RoomName'] . " , ";
                        $guests = $roomDetails->getElementsByTagName("GuestInfo")->item(0)->getElementsByTagName("Guest");
                        $room['Guests'] = array();
                        foreach ($guests as $guest) {
                            $gue['LeadGuest'] = $guest->getAttribute("LeadGuest");
                            $gue['GuestType'] = $guest->getAttribute("GuestType");
                            $gue['GuestInRoom'] = $guest->getAttribute("GuestInRoom");
                            $gue['Title'] = $guest->getElementsByTagName("Title")->item(0)->nodeValue;
                            $gue['FirstName'] = $guest->getElementsByTagName("FirstName")->item(0)->nodeValue;
                            $gue['LastName'] = $guest->getElementsByTagName("LastName")->item(0)->nodeValue;
                            $gue['Age'] = $guest->getElementsByTagName("Age")->item(0)->nodeValue;
                            array_push($room['Guests'], $gue);
                        }

                        if ($roomDetails->getElementsByTagName("RoomPromtion")->length > 0) {
                            $room['RoomPromtion'] = $roomDetails->getElementsByTagName("RoomPromtion")->item(0)->nodeValue;
                        }
                        if ($roomDetails->getElementsByTagName("MealType")->length > 0) {
                            $room['MealType'] = $roomDetails->getElementsByTagName("MealType")->item(0)->nodeValue;
                        }
                        if ($roomDetails->getElementsByTagName("Supplements")->length > 0) {
                            $supplements = $roomDetails->getElementsByTagName("Supplements")->item(0)->getElementsByTagName("Supp_info");
                            $room['Supplements'] = array();
                            foreach ($supplements as $supplement) {
                                $supp['Type'] = $supplement->getAttribute("Type");
                                $supp['SuppName'] = $supplement->getAttribute("SuppName");
                                $supp['SuppChargeType'] = $supplement->getAttribute("SuppChargeType");
                                $supp['Price'] = $supplement->getAttribute("Price");
                                $supp['Currency'] = $supplement->getAttribute("Currency");
                                array_push($room['Supplements'], $supp);
                            }
                        }

                        $room['IsPackageRate'] = $roomDetails->getElementsByTagName("RoomRate")->item(0)->getAttribute("IsPackageRate");
                        $room['B2CRates'] = $roomDetails->getElementsByTagName("RoomRate")->item(0)->getAttribute("B2CRates");
                        $room['AgentMarkUp'] = $roomDetails->getElementsByTagName("RoomRate")->item(0)->getAttribute("AgentMarkUp");
                        $room['Currency'] = $roomDetails->getElementsByTagName("RoomRate")->item(0)->getAttribute("Currency");
                        $room['RoomFare'] = $roomDetails->getElementsByTagName("RoomRate")->item(0)->getAttribute("RoomFare");
                        $room['RoomTax'] = $roomDetails->getElementsByTagName("RoomRate")->item(0)->getAttribute("RoomTax");
                        $room['TotalFare'] = $roomDetails->getElementsByTagName("RoomRate")->item(0)->getAttribute("TotalFare");
                        $totPrice += $room['TotalFare'];
                        $room['ExtraGuestCharges'] = $roomDetails->getElementsByTagName("RoomRate")->item(0)->getElementsByTagName("ExtraGuestCharges")->item(0)->nodeValue;
                        $room['ChildCharges'] = $roomDetails->getElementsByTagName("RoomRate")->item(0)->getElementsByTagName("ChildCharges")->item(0)->nodeValue;
                        $room['Discount'] = $roomDetails->getElementsByTagName("RoomRate")->item(0)->getElementsByTagName("Discount")->item(0)->nodeValue;
                        $room['OtherCharges'] = $roomDetails->getElementsByTagName("RoomRate")->item(0)->getElementsByTagName("OtherCharges")->item(0)->nodeValue;
                        $room['ServiceTax'] = $roomDetails->getElementsByTagName("RoomRate")->item(0)->getElementsByTagName("ServiceTax")->item(0)->nodeValue;

                        array_push($data['RoomsDetails'], $room);
                    }
                    $data['roomsname'] = $roomsname;
                }

                return ['data' => $data, 'xmlbookDetailResponse' => $xmlbookDetailResponse];
            }
        }

        throw new Exception("Supplier Error! {$data['BookingDesc']}");
    }

    //============================================== Generate Invoice ====================================
    public function generate_invoice($confirmation_number)
    {
        try {


            // $this->api->db->insert('errors_logs', [
            //     'method_name'   =>  __METHOD__,
            //     'message'   =>  'Inside generate invoice function',
            //     'data'  =>  json_encode($confirmation_number),
            //     'type'  =>  'test'
            // ]);

            $xml_response = $this->tboholidays_sdk->generate_invoice($confirmation_number);

            // $this->api->db->insert('errors_logs', [
            //     'method_name'   =>  __METHOD__,
            //     'message'   =>  'Inside generate invoice function',
            //     'data'  =>  json_encode($xml_response),
            //     'type'  =>  'test'

            // ]);

            // $myfile = fopen("generate_invoice_response.xml", "w");
            // fwrite($myfile, $xml_response);
            // fclose($myfile);

            $booking_invoice_number = '';

            $doc = new DOMDocument('1.0', 'utf-8');
            $doc->loadXML($xml_response);

            // $this->api->db->insert('errors_logs', [
            //     'method_name'   =>  __METHOD__,
            //     'message'   =>  'Inside generate invoice function',
            //     'data'  =>  json_encode($doc),
            //     'type'  =>  'test'

            // ]);

            if ($doc->getElementsByTagName("InvoiceNo")->length > 0) {
                //$data['conf'] = $doc->getElementsByTagName("ConfirmationNo")->item(0)->nodeValue;
                $booking_invoice_number = $doc->getElementsByTagName("InvoiceNo")->item(0)->nodeValue;
                // $this->api->db->where('confirmation_number', $confirmation_number);
                // $this->api->db->update('hotels_booking_list', array(
                //     'invoice_number'    =>    $booking_invoice_number,
                //     'booking_status'    =>    'Vouchered',
                //     'voucher_status'    =>    'true'
                // ));
            }

            return $booking_invoice_number;
        } catch (Exception $e) {
            throw new Exception('Error creating invoice number' . $e->getMessage());
        }
    }
}
