<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\Flights\Entities\FlightsSearch;
use Modules\Hotels\Entities\HotelsSearch;

class WowSession extends Model
{
    use HasFactory;
    protected $table = 'wow_sessions';
    protected $fillable = [
        'key',
        'module',
        'supplier',
        'data',
        'query'
    ];
    protected $casts = [
        'data' => 'array',
        'query' => 'array'
    ];

    // public function hotels_search()
    // {
    //     return $this->hasOne(HotelsSearch::class, 'session_id');
    // }
    public function flights_search()
    {
        return $this->hasOne(FlightsSearch::class);
    }
}
