{{-- Extends layout --}}
@extends('admin.layout.default')
@push('style')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.5.1/min/dropzone.min.css" rel="stylesheet" />
@endpush
{{-- Content --}}
@section('content')
    <div class="container-fluid">
        <div class="row page-titles mx-0 mb-3">
            <div class="col-sm-6 p-0">
                <div class="welcome-text">
                    <h4>{{ __('Supplier') }}</h4>
                    <span>{{ __('Add Suppliers') }}</span>
                </div>
            </div>
            <div class="col-sm-6 p-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.suppliers.index') }}">{{ __('suppliers') }}</a>
                    </li>
                    <li class="breadcrumb-item active"><a href="javascript:void(0)">{{ __('Add Supplier') }}</a></li>
                </ol>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">{{ __('Add Supplier') }}</h4>
            </div>
            <form action="{{ route('admin.suppliers.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card-body">
                    <div class="basic-form">
                        <div class="row align-items-center">
                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label>{{ __('Name') }}</label>
                                        <input type="text" name="name" id="name" class="form-control"
                                            autocomplete="name" value="{{ old('name') }}">
                                        @error('first_name')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>{{ __('module') }}</label>
                                        <input type="text" name="module_key" id="module_key" class="form-control"
                                            value="{{ old('module_key') }}">
                                        @error('module_key')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-6">
                                        <label>{{ __('Desc') }}</label>
                                        <input type="text" name="desc" id="desc" class="form-control"
                                            value="{{ old('desc') }}">
                                        @error('desc')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-6">
                                        <label>{{ __('Supplier Key') }}</label>
                                        <input type="number" name="key" id="key" class="form-control"
                                            value="{{ old('key') }}">
                                        @error('key')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>

                                    <div class="form-group col-6">
                                        <label>{{ __('Nationality Ar') }}</label>
                                        <input type="text" name="nationality_ar" id="nationality_ar"
                                            class="form-control" value="{{ old('nationality_ar') }}">
                                        @error('nationality_ar')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>

                                 

                                    <div class="form-group col-6">
                                        <label>{{ __('region') }}</label>
                                        <input type="text" name="region" id="region" class="form-control"
                                            value="{{ old('region') }}">
                                        @error('region')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>

                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12">
                                    <textarea name="desc_ar" class="form-control wowwsCkeditor h-auto" id="DescAR" rows="10">{{ old('data.Page.content') }}</textarea>
                                    @error('desc_ar')
                                        <p class="text-danger">
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12">
                                    <textarea name="desc_en" class="form-control wowwsCkeditor h-auto" id="Desc_EN" rows="10">{{ old('data.Page.content') }}</textarea>
                                    @error('desc_en')
                                        <p class="text-danger">
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                            <a href="{{ route('admin.suppliers.index') }}"
                                class="btn btn-danger">{{ __('Back') }}</a>
                        </div>
            </form>
        </div>

    </div>

@endsection
