<?php

namespace Modules\Locales\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Modules\Locales\Entities\Currency;
use Modules\Locales\Http\Controllers\Api\Admins\CurrencyController;

class CurrenciesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $currencyController = new CurrencyController;

        $currencies = $currencyController->json_currency_list();
        $rates = $currencyController->get_currencies_rates(env('BASE_CURRENCY', 'SAR'));
        $currencyController->update_base_currency(env('BASE_CURRENCY', 'SAR'));
        $currency_list = [];
        foreach ($currencies as $currency) {
            foreach ($rates as $code => $rate) {
                if ($code == $currency['code']) {
                    $currency['value'] = $rate;
                }
            }
            $currency_list[] = $currency;
        }
        foreach ($currency_list as $currency) {
            Currency::updateOrCreate(['code' => $currency['code']], $currency);
        }
    }
}
