<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMarkupsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('markups', function (Blueprint $table) {
            $table->id();
            $table->string('model_name');
            $table->string('model_type');
            $table->bigInteger('model_id');
            $table->string('type');
            $table->integer('amount_b2c');
            $table->integer('amount_b2b');
            $table->integer('amount_mobile');
            $table->integer('percentage_b2c');
            $table->integer('percentage_b2b');
            $table->integer('percentage_mobile');
            $table->integer('max')->default(0);
            $table->integer('min')->default(0);
            $table->boolean('ongoing');
            $table->timestamp('reservation_from')->nullable();
            $table->timestamp('reservation_to')->nullable();
            $table->timestamp('booking_from')->nullable();
            $table->timestamp('booking_to')->nullable();
            $table->text('overwrite')->nullable();
            $table->json('identifier')->nullable();
            $table->timestamps();
            $table->unique(['model_type', 'model_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('markups');
    }
}
