<?php

namespace Modules\Payments\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Users\Entities\User;

class Payment extends Model
{
    const STATUS_PAID = 'paid';
    const STATUS_UNPAID = 'unpaid';
    const STATUS_PENDING = 'pending';

    protected $fillable = [
        'module',
        'supplier',
        'user_id',
        'company_id',
        'added_by',
        'booking_id',
        'amount',
        'currency',
        'type',
        'status',
        'created_at'
    ];

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function company()
    {
        return $this->hasOne(User::class, 'id', 'company_id')->select('id', 'image');
    }

    public function added_by()
    {
        return $this->hasOne(User::class, 'id', 'added_by');
    }
}
