<?php

namespace Modules\Settings\Http\Controllers\Api\Admins;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Routing\Controller;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Auth;
use Modules\Settings\Entities\Settings;
use Modules\Settings\Entities\UserSettings;
use Illuminate\Http\Request;

class SettingsController extends Controller
{

    public $client;
    public function __construct(Request $req)
    {
        $headers = [
            // 'X-Authorization-Token' =>  env('API_TOKEN'),
            'X-Access-Token' =>  env('API_TOKEN'),
            'X-Language-Code' => $req->header('X-Language-Code'),
            'X-Country-Code' => $req->header('X-Country-Code'),
            'X-Currency-Code' => $req->header('X-Currency-Code'),
            'X-Client-IP' => $req->ip()
        ];

        if ($req->header('X-Session')) {
            $headers['X-Session'] = $req->header('X-Session');
        }

        $this->client = new Client([
            'base_uri' => env('API_MODULE_BASE'),
            'headers' => $headers
        ]);
    }
    // ======================================== return modules with suppliers ===========================
    public function modules()
    {
        try {
            $response = $this->client->get('users/user_permissions');
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => 'Internal Server Error'
            ], 500);
        }
        $response = json_decode($response->getBody()->getContents());
        if ($response->status) {
            $modules = [];
            foreach ($response->data->Permissions as $module) {
                $moduleData = [
                    'moduleId' => (int) $module->ModuleId,
                    'moduleName' => $module->ModuleName,
                    'suppliers' => []
                ];
                if (!empty($module->Suppliers)) {

                    $suppliers = [];
                    foreach ($module->Suppliers as $supplier) {
                        $suppliers[] = [
                            'supplierId' => (int) $supplier->SupplierId,
                            'supplierName' =>  explode('_', $supplier->PermissionKey)[1]
                        ];
                    }
                    $moduleData['suppliers'] = $suppliers;
                }
                $modules[] = $moduleData;
            }
        }
        return response()->json([
            'status' => true,
            'data' => [
                'modules' => $modules
            ]
        ]);
    }
    //========================================Supplier Setting ==============================================
    public function supplier_settings($module, $supplier)
    {
        $response = $this->client->get($module . '//supplier_settings/' . $supplier);
        return response()->json(json_decode((string)$response->getBody()));
    }

    public function update_supplier_settings(Request $req, $module, $supplier)
    {
        $validated = $req->validate([
            'username' => 'required',
            'password' => 'required'
        ]);
        $response = $this->client->post($module . '//update_supplier_settings/' . $supplier, ['json' => $validated, 'http_errors' => false]);
        return response()->json(json_decode((string)$response->getBody()));
    }
    public function supplier_settings_form($module, $supplier)
    {
        $response = $this->client->get($module . '//supplier_form/' . $supplier);
        return response()->json(json_decode((string)$response->getBody()));
    }

    // ========================================================website settings ==============================

    public function store(Request $req)
    {
        $validatedData = $req->validate([
            // 'user_id' => 'required|unique:settings',
            'language' => 'required',
            'type' => 'required',
        ]);

        $data = $req->only('user-id', 'type', 'language', 'meta_title', 'meta_description', 'meta_short_url', 'meta_tags', 'meta_keywords', 'meta_head', 'slug', 'logo', 'logo_black', 'fav_icon');
        $settings = Settings::create([
            'user_id' => $req['user_id'],
            'language' => $req['language'],
            'type' => $req['type'],
            'content' => $data['content'],
        ]);
        return json_response($settings, 200, $settings ? true : false, $settings ? trans('web.updated_successfully') : trans('web.req_failed'));
    }


    public function show($type, $id = null, UserSettings $settings)
    {
        return $type;
        if ($type == 'user') {
            $settings = UserSettings::where('user_id', $id)->first();
        } else if ($type == 'public') {
            $settings = UserSettings::where('user_id', Auth::id())->first();
        } else {
            $settings = Settings::where('type', $type)->first();
        }
        if (!$settings) {
            return json_response(null);
        }
        return json_response($settings->content, 200, $settings ? true : false, '');
    }


    public function update($type, Request $req)
    {
        if ($type == 'user') {
            $data = $req->only('balance_notification_limit', 'pay_channel', 'buffer_days', 'pay_later', 'balance_margin');
            $settings = UserSettings::updateOrCreate([
                'user_id'   => $req->user_id
            ], $data);
            return json_response($settings, 200, $settings ? true : false, $settings ? trans('web.updated_successfully') : trans('web.req_failed'));
        } else if ($type == 'public') {
            $data = $req->only('balance_notification_limit', 'search_timeout', 'pay_channel', 'buffer_days', 'pay_later', 'balance_margin');
            $settings = Settings::updateOrCreate([
                'type'   => $type
            ], [
                'content' => $data
            ]);
            return json_response($settings, 200, $settings ? true : false, $settings ? trans('web.updated_successfully') : trans('web.req_failed'));
        } else if ($type == 'credentials') {
            $data = $req->only('frontend_url', 'backend_url', 'access_token');
            $settings = Settings::updateOrCreate([
                'type'   => $type
            ], [
                'content' => $data
            ]);
            return json_response($settings, 200, $settings ? true : false, $settings ? trans('web.updated_successfully') : trans('web.req_failed'));
        }
    }

    //======================================================app settings ==================
    public function updateAppSettings(Request $request)
    {
        $user = Auth::user();
        if ($user->email == env('ADMIN_EMAIL')) {
            $validated = $request->validate([
                'frontend_url' => 'required|url',
                'backend_url' => 'required|url',
                'access_token' => 'required|uuid',
                'password' => 'required'
            ]);
            $response = $this->client->post('users/settings_edit', ['json' => $validated, 'http_errors' => false]);
            return response((string) $response->getBody(), $response->getStatusCode());
        }
        return json_response('', 401, false, 'Authentication failed');
    }

    public function getAppSettings()
    {
        $user = Auth::user();
        if ($user->email == env('ADMIN_EMAIL')) {
            $response = $this->client->get('users/app_settings');
            return response((string) $response->getBody(), $response->getStatusCode());
        }
        return json_response('', 500, false, 'Authentication failed');
    }
    //============================================Public Settings============
    public function getPublicSettings(Request $req, $id = null)
    {
        $user_id = $id ?? auth()->user()->id;
        if ($user_id) {
            $settings = UserSettings::where('user_id', $user_id)->first();
        }
        return json_response($settings ?? null, 200, true, '');
    }

    public function updatePublicSettings(Request $req)
    {
        $id = $req->user_id ?? auth()->user()->id;
        $data = $req->only('balance_notification_limit', 'pay_channel', 'buffer_days', 'pay_later', 'balance_margin','search_timeout');
        $settings = UserSettings::updateOrCreate([
            'user_id'   => $id
        ], $data);
        return json_response($settings, 200, $settings ? true : false, $settings ? trans('web.updated_successfully') : trans('web.req_failed'));
    }
}
