<?php

use Illuminate\Http\Request;
use Modules\Settings\Http\Controllers\SettingsController;
use Modules\Settings\Http\Controllers\Api\Admins\SettingsController as AdminSettings;

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::group(['middleware' => 'language', 'has_permission', 'logger'], function () {
    Route::group(['prefix' => 'admins/'], function () {
        //supplier settings
        Route::group(['prefix' => 'supplier_settings'], function () {
            Route::get('/modules', [AdminSettings::class, 'modules'])->name('settings_get_modules');
            Route::get('{module}/form/{supplier}', [AdminSettings::class, 'supplier_settings_form'])->name('settings_get_supplier_settings');
            Route::get('{module}/{supplier}', [AdminSettings::class, 'supplier_settings'])->name('settings_get_supplier_settings');
            Route::post('{module}/{supplier}', [AdminSettings::class, 'update_supplier_settings'])->name('settings_update_supplier_settings');
        });

        Route::group(['prefix' => 'settings', 'middleware' => 'auth:sanctum'], function () {
            Route::group(['prefix' => '/public'], function () {
                Route::get('/show/{id?}', [AdminSettings::class, 'getPublicSettings'])->name('settings_get_public_settings');
                Route::post('/update', [AdminSettings::class, 'updatePublicSettings'])->name('settings_update_public_settings');
            });
            Route::group(['prefix' => '/app'], function () {
                Route::get('/show', [AdminSettings::class, 'getAppSettings'])->name('settings_get_app_settings');
                Route::post('/update', [AdminSettings::class, 'updateAppSettings'])->name('settings_update_app_settings');
            });
        });
    });
});
