<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class BalanceNotificationCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'balancenotification:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send notification for balance limit exceeded';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        \Log::info("balance check for users ...");
        $user_settings=UserSetting::all();
        foreach($user_settings as $setting){
            $user_balance=User::where('id',$setting->user_id)->first()->credit_amount;
            if($user_balance < $setting->balance_notification_limit){
                $this->notify($setting->email);
            }
        }
        // return 0;
    }

    public function notify($email){
        // notification email
    }
}

