import "./chunk-C5HQ7SH6.js";
import "./chunk-G5T4DE72.js";
import {
  createElementBlock,
  createTextVNode,
  defineComponent,
  openBlock,
  renderSlot
} from "./chunk-MIX45QWY.js";
import {
  toDisplayString
} from "./chunk-NMW5XHJU.js";
import "./chunk-OROXOI2D.js";

// node_modules/vue-json-excel3/dist/vue-json-excel.esm.js
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function createCommonjsModule(fn, module) {
  return module = { exports: {} }, fn(module, module.exports), module.exports;
}
var download = createCommonjsModule(function(module, exports) {
  (function(root, factory) {
    {
      module.exports = factory();
    }
  })(commonjsGlobal, function() {
    return function download2(data, strFileName, strMimeType) {
      var self2 = window, defaultMime = "application/octet-stream", mimeType = strMimeType || defaultMime, payload = data, url = !strFileName && !strMimeType && payload, anchor = document.createElement("a"), toString = function(a) {
        return String(a);
      }, myBlob = self2.Blob || self2.MozBlob || self2.WebKitBlob || toString, fileName = strFileName || "download", blob, reader;
      myBlob = myBlob.call ? myBlob.bind(self2) : Blob;
      if (String(this) === "true") {
        payload = [payload, mimeType];
        mimeType = payload[0];
        payload = payload[1];
      }
      if (url && url.length < 2048) {
        fileName = url.split("/").pop().split("?")[0];
        anchor.href = url;
        if (anchor.href.indexOf(url) !== -1) {
          var ajax = new XMLHttpRequest();
          ajax.open("GET", url, true);
          ajax.responseType = "blob";
          ajax.onload = function(e) {
            download2(e.target.response, fileName, defaultMime);
          };
          setTimeout(function() {
            ajax.send();
          }, 0);
          return ajax;
        }
      }
      if (/^data:([\w+-]+\/[\w+.-]+)?[,;]/.test(payload)) {
        if (payload.length > 1024 * 1024 * 1.999 && myBlob !== toString) {
          payload = dataUrlToBlob(payload);
          mimeType = payload.type || defaultMime;
        } else {
          return navigator.msSaveBlob ? navigator.msSaveBlob(dataUrlToBlob(payload), fileName) : saver(payload);
        }
      } else {
        if (/([\x80-\xff])/.test(payload)) {
          var i = 0, tempUiArr = new Uint8Array(payload.length), mx = tempUiArr.length;
          for (i; i < mx; ++i)
            tempUiArr[i] = payload.charCodeAt(i);
          payload = new myBlob([tempUiArr], { type: mimeType });
        }
      }
      blob = payload instanceof myBlob ? payload : new myBlob([payload], { type: mimeType });
      function dataUrlToBlob(strUrl) {
        var parts = strUrl.split(/[:;,]/), type = parts[1], decoder = parts[2] == "base64" ? atob : decodeURIComponent, binData = decoder(parts.pop()), mx2 = binData.length, i2 = 0, uiArr = new Uint8Array(mx2);
        for (i2; i2 < mx2; ++i2)
          uiArr[i2] = binData.charCodeAt(i2);
        return new myBlob([uiArr], { type });
      }
      function saver(url2, winMode) {
        if ("download" in anchor) {
          anchor.href = url2;
          anchor.setAttribute("download", fileName);
          anchor.className = "download-js-link";
          anchor.innerHTML = "downloading...";
          anchor.style.display = "none";
          document.body.appendChild(anchor);
          setTimeout(function() {
            anchor.click();
            document.body.removeChild(anchor);
            if (winMode === true) {
              setTimeout(function() {
                self2.URL.revokeObjectURL(anchor.href);
              }, 250);
            }
          }, 66);
          return true;
        }
        if (/(Version)\/(\d+)\.(\d+)(?:\.(\d+))?.*Safari\//.test(navigator.userAgent)) {
          if (/^data:/.test(url2))
            url2 = "data:" + url2.replace(/^data:([\w\/\-\+]+)/, defaultMime);
          if (!window.open(url2)) {
            if (confirm("Displaying New Document\n\nUse Save As... to download, then click back to return to this page.")) {
              location.href = url2;
            }
          }
          return true;
        }
        var f = document.createElement("iframe");
        document.body.appendChild(f);
        if (!winMode && /^data:/.test(url2)) {
          url2 = "data:" + url2.replace(/^data:([\w\/\-\+]+)/, defaultMime);
        }
        f.src = url2;
        setTimeout(function() {
          document.body.removeChild(f);
        }, 333);
      }
      if (navigator.msSaveBlob) {
        return navigator.msSaveBlob(blob, fileName);
      }
      if (self2.URL) {
        saver(self2.URL.createObjectURL(blob), true);
      } else {
        if (typeof blob === "string" || blob.constructor === toString) {
          try {
            return saver("data:" + mimeType + ";base64," + self2.btoa(blob));
          } catch (y) {
            return saver("data:" + mimeType + "," + encodeURIComponent(blob));
          }
        }
        reader = new FileReader();
        reader.onload = function(e) {
          saver(this.result);
        };
        reader.readAsDataURL(blob);
      }
      return true;
    };
  });
});
var script = defineComponent({
  props: {
    type: {
      type: String,
      default: "xls"
    },
    data: {
      type: Array,
      required: false,
      default: null
    },
    fields: {
      type: Object,
      default: () => null
    },
    exportFields: {
      type: Object,
      default: () => null
    },
    defaultValue: {
      type: String,
      required: false,
      default: ""
    },
    header: {
      default: null
    },
    footer: {
      default: null
    },
    name: {
      type: String,
      default: "data.xls"
    },
    fetch: {
      type: Function
    },
    meta: {
      type: Array,
      default: () => []
    },
    worksheet: {
      type: String,
      default: "Sheet1"
    },
    beforeGenerate: {
      type: Function
    },
    beforeFinish: {
      type: Function
    },
    escapeCsv: {
      type: Boolean,
      default: true
    },
    stringifyLongNum: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    idName() {
      var now = new Date().getTime();
      return "export_" + now;
    },
    downloadFields() {
      if (this.fields)
        return this.fields;
      if (this.exportFields)
        return this.exportFields;
    }
  },
  methods: {
    async generate() {
      if (typeof this.beforeGenerate === "function") {
        await this.beforeGenerate();
      }
      let data = this.data;
      if (typeof this.fetch === "function" || !data)
        data = await this.fetch();
      if (!data || !data.length) {
        return;
      }
      let json = this.getProcessedJson(data, this.downloadFields);
      if (this.type === "html") {
        return this.export(
          this.jsonToXLS(json),
          this.name.replace(".xls", ".html"),
          "text/html"
        );
      } else if (this.type === "csv") {
        return this.export(
          this.jsonToCSV(json),
          this.name.replace(".xls", ".csv"),
          "application/csv"
        );
      }
      return this.export(
        this.jsonToXLS(json),
        this.name,
        "application/vnd.ms-excel"
      );
    },
    export: async function(data, filename, mime) {
      let blob = this.base64ToBlob(data, mime);
      if (typeof this.beforeFinish === "function")
        await this.beforeFinish();
      download(blob, filename, mime);
    },
    jsonToXLS(data) {
      let xlsTemp = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><meta name=ProgId content=Excel.Sheet> <meta name=Generator content="Microsoft Excel 11"><meta http-equiv="Content-Type" content="text/html; charset=UTF-8"><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>${worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--><style>br {mso-data-placement: same-cell;}</style></head><body><table>${table}</table></body></html>';
      let xlsData = "<thead>";
      const colspan = Object.keys(data[0]).length;
      let _self = this;
      const header = this.header || this.$attrs.title;
      if (header) {
        xlsData += this.parseExtraData(
          header,
          '<tr><th colspan="' + colspan + '">${data}</th></tr>'
        );
      }
      xlsData += "<tr>";
      for (let key in data[0]) {
        xlsData += "<th>" + key + "</th>";
      }
      xlsData += "</tr>";
      xlsData += "</thead>";
      xlsData += "<tbody>";
      data.map(function(item, index) {
        xlsData += "<tr>";
        for (let key in item) {
          xlsData += "<td>" + _self.preprocessLongNum(
            _self.valueReformattedForMultilines(item[key])
          ) + "</td>";
        }
        xlsData += "</tr>";
      });
      xlsData += "</tbody>";
      if (this.footer != null) {
        xlsData += "<tfoot>";
        xlsData += this.parseExtraData(
          this.footer,
          '<tr><td colspan="' + colspan + '">${data}</td></tr>'
        );
        xlsData += "</tfoot>";
      }
      return xlsTemp.replace("${table}", xlsData).replace("${worksheet}", this.worksheet);
    },
    jsonToCSV(data) {
      let _self = this;
      var csvData = [];
      const header = this.header || this.$attrs.title;
      if (header) {
        csvData.push(this.parseExtraData(header, "${data}\r\n"));
      }
      for (let key in data[0]) {
        csvData.push(key);
        csvData.push(",");
      }
      csvData.pop();
      csvData.push("\r\n");
      data.map(function(item) {
        for (let key in item) {
          let escapedCSV = item[key] + "";
          if (_self.escapeCsv) {
            escapedCSV = '="' + escapedCSV + '"';
            if (escapedCSV.match(/[,"\n]/)) {
              escapedCSV = '"' + escapedCSV.replace(/\"/g, '""') + '"';
            }
          }
          csvData.push(escapedCSV);
          csvData.push(",");
        }
        csvData.pop();
        csvData.push("\r\n");
      });
      if (this.footer != null) {
        csvData.push(this.parseExtraData(this.footer, "${data}\r\n"));
      }
      return csvData.join("");
    },
    getProcessedJson(data, header) {
      let keys = this.getKeys(data, header);
      let newData = [];
      let _self = this;
      data.map(function(item, index) {
        let newItem = {};
        for (let label in keys) {
          let property = keys[label];
          newItem[label] = _self.getValue(property, item);
        }
        newData.push(newItem);
      });
      return newData;
    },
    getKeys(data, header) {
      if (header) {
        return header;
      }
      let keys = {};
      for (let key in data[0]) {
        keys[key] = key;
      }
      return keys;
    },
    parseExtraData(extraData, format) {
      let parseData = "";
      if (Array.isArray(extraData)) {
        for (var i = 0; i < extraData.length; i++) {
          if (extraData[i])
            parseData += format.replace("${data}", extraData[i]);
        }
      } else {
        parseData += format.replace("${data}", extraData);
      }
      return parseData;
    },
    getValue(key, item) {
      const field = typeof key !== "object" ? key : key.field;
      let indexes = typeof field !== "string" ? [] : field.split(".");
      let value = this.defaultValue;
      if (!field)
        value = item;
      else if (indexes.length > 1)
        value = this.getValueFromNestedItem(item, indexes);
      else
        value = this.parseValue(item[field]);
      if (key.hasOwnProperty("callback"))
        value = this.getValueFromCallback(value, key.callback);
      return value;
    },
    valueReformattedForMultilines(value) {
      if (typeof value == "string")
        return value.replace(/\n/gi, "<br/>");
      else
        return value;
    },
    preprocessLongNum(value) {
      if (this.stringifyLongNum) {
        if (String(value).startsWith("0x")) {
          return value;
        }
        if (!isNaN(value) && value != "") {
          if (value > 99999999999 || value < 1e-13) {
            return '="' + value + '"';
          }
        }
      }
      return value;
    },
    getValueFromNestedItem(item, indexes) {
      let nestedItem = item;
      for (let index of indexes) {
        if (nestedItem)
          nestedItem = nestedItem[index];
      }
      return this.parseValue(nestedItem);
    },
    getValueFromCallback(item, callback) {
      if (typeof callback !== "function")
        return this.defaultValue;
      const value = callback(item);
      return this.parseValue(value);
    },
    parseValue(value) {
      return value || value === 0 || typeof value === "boolean" ? value : this.defaultValue;
    },
    base64ToBlob(data, mime) {
      let base64 = window.btoa(window.unescape(encodeURIComponent(data)));
      let bstr = atob(base64);
      let n = bstr.length;
      let u8arr = new Uint8ClampedArray(n);
      while (n--) {
        u8arr[n] = bstr.charCodeAt(n);
      }
      return new Blob([u8arr], { type: mime });
    }
  }
});
var _hoisted_1 = ["id"];
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    id: _ctx.idName,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.generate && _ctx.generate(...args))
  }, [
    renderSlot(_ctx.$slots, "default", {}, () => [
      createTextVNode(" Download " + toDisplayString(_ctx.name), 1)
    ])
  ], 8, _hoisted_1);
}
script.render = render;
script.__file = "JsonExcel.vue";
var vue_json_excel_esm_default = script;

// dep:vue-json-excel3
var vue_json_excel3_default = vue_json_excel_esm_default;
export {
  vue_json_excel3_default as default
};
//# sourceMappingURL=vue-json-excel3.js.map
