import store from '@/state'
const base_url = store.state.b2c.backend_url
export default {
    //GET
    pages: {
        list(){
            return base_url + '/api/pages/'
        },
        add(){
            return base_url + '/api/pages/'
        },
        edit(id){
            return base_url + '/api/pages/'+ id
        },
        delete(id){
            return base_url + '/api/pages/' + id
        },
    },
    sections: {
        list(){
            return base_url + '/api/content-sections/'
        },
        add(){
            return base_url + '/api/content-sections/'
        },
        edit(id){
            return base_url + '/api/content-sections/'+ id
        },
        delete(id){
            return base_url + '/api/content-sections/' + id
        },
    },
    pages_sections: {
        list(){
            return base_url + '/api/pages-sections/'
        },
        add(){
            return base_url + '/api/pages-sections/'
        },
        edit(id){
            return base_url + '/api/pages-sections/'+ id
        },
        delete(id){
            return base_url + '/api/pages-sections/' + id
        },
    },
    links: {
        list(){
            return base_url + '/api/links/'
        },
        add(){
            return base_url + '/api/links/'
        },
        edit(id){
            return base_url + '/api/links/'+ id
        },
        delete(id){
            return base_url + '/api/links/' + id
        },
    },
    faq: {
        list(){
            return base_url + '/api/faq/'
        },
        add(){
            return base_url + '/api/faq/'
        },
        edit(id){
            return base_url + '/api/faq/'+ id
        },
        delete(id){
            return base_url + '/api/faq/' + id
        },
        not_answered_list() {
            return base_url + '/api/faq/not_answered/list'
        },
        delete_not_answered(id) {
            return base_url + '/api/faq/not_answered/' + id
        },
    },
    
}