export default {
    //GET
    autocomplete_search(query) {
        return '/hotels/auto_complete/' + query
    },
    search: {
        //GET
        static: () => '/hotels/static_result',
        //GET
        live: () => '/hotels/search',
    },
    details: {
        //GET
        details: (id) => '/hotels/local_hotel_details/' + id,
        //GET
        available_rooms: (hid, session_id) => `/hotels/available_rooms?hid=${hid}&session_id=${session_id}`,
    },
    book: {
        //GET
        hotel_details: (params) => '/hotels/pricing?' + params,
        //POST
        hotel_book: () => '/hotels/booking',
        //GET
        hotel_book_details: (merchant_ref) => '/hotels/booking_details?merchant_ref=' + merchant_ref,
    },
    booking_details(merchant_ref) {
        return `/hotels/booking_details/${merchant_ref}`
    },
    cancel_booking(merchant_ref) {
        return `/hotels/cancel_booking/${merchant_ref}`
    },
    bookDetails(merchant_ref) {
        return `/hotels/book-details/${merchant_ref}`
    },
    booking_list(page) {
        page = (page || 1)
        return `/hotels/local_booking_list?page=${page}&page%5Bnumber%5D=${page}`
    },
    pre_payment(id) {
        return '/hotels/pre_payment/' + id
    },
    invoice(id) {
        return '/hotels/invoice/' + id
    }, countryList() {
        return '/hotels/country/list'
    },
    nationalityList() {
        return '/hotels/nationality/list'
    },
}