export default {
    list(type,company_id) {
        switch(type){
            case 'company': return '/users/list_companies'
            case 'company_employees': return `/users/list_company_employees/${company_id}`
            case 'employee':
            default: return '/users/list_employees'
        }
    },
    add(type,company_id){
        switch(type){
            case 'company': return '/users/add_company'
            case 'company_employees': return `/users/add_employee/${company_id}`
            case 'employee':
            default: return '/users/add_employee'
        }
    },
    edit(id, type) {
        switch(type){
            case 'company': return `/users/update_company/${id}`
            case 'company_employees': return `/users/update_employee/${id}`
            case 'employee':
            default: return `/users/update_employee/${id}`
        }
    },
    // show(id){
    //     return '/users/sub_user_profile/' + id
    // },
    delete(id) {
        return `/users/delete/${id}`
    },
    group_list(){
        return '/users/group_list'
    },
    company_group_list(){
        return '/users/groups/list'
    },
    //id = subuser id & type = one of [all|user|group]
    user_permissions(id) {
        return `/users/permissions/list/${id}`
    },
    user_groups(id){
        return `/users/user_groups/${id}`
    },
    user_groups(id){
        return `/users/user_groups/${id}`
    },
    permissions(id) {
        return `/users/permissions/available/${id}`
    },
    addBalance(id){
        return `/users/update_credit_amount/${id}`
    },
    // user_groups_permissions(id=null) {
    //     return '/users/user_groups_permissions?' + ( id ? 'user_id=' + id : '')
    // },
    edit_user_permissions(id){
        return `/users/permissions/assign/${id}`
    },
    company_group: {
        add(){
            return '/users/groups/create'
        },
        edit(id){
            return '/users/groups/update/'+ id
        },
        delete(id){
            return `/users/groups/delete/${id}`
        },
        editPermissions(){
            return '/users/groups/assign_permissions'
        },
        permissions(id) {
            return '/users/groups/permissions/' + id
        }
    },
}
