import flights_menu from '@/modules/flights/menu/menu.json'
import hotels_menu from '@/modules/hotels/menu/menu.json'
import content_menu from '@/modules/content/menu/menu.json'
import users_menu from '@/modules/users/menu/menu.json'
import reports_menu from '@/modules/reports/menu/menu.json'
import logs_menu from '@/modules/logs/menu/menu.json'
// import markups_menu from '@/modules/markups/menu/menu.json'
import settings_menu from '@/modules/settings/menu/menu.json'
import store from '@/state'
const menu_list = {
    flights: flights_menu,
    hotels: hotels_menu,
    content: content_menu,
    users: users_menu,
    reports: reports_menu,
    logs: logs_menu,
    // markups: markups_menu,
    settings: settings_menu
}
export function getCurrentPageMenu(page) {
    let menu =  menu_list[page] || []
    return menu.filter(item => {
        if(!item.hasOwnProperty('permission')) return true

        return store.hasPermission(item.permission)
    })
}
