<?php

namespace Modules\Hotels\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hotels\Http\Controllers\SDK\Dotw\DotwSdkController;
use Psr\Http\Message\RequestInterface;

use function PHPUnit\Framework\throwException;

class DotwController extends Controller
{
    protected $module_key;
    protected $supplier_key;
    protected $loginId = '';
    protected $password = '';
    protected $companyCode = '';
    protected $settings = [];
    protected $dotw_sdk;
    protected $session_key;
    protected $supplier_id;
    protected $currency;

    public function __construct(Request $request)
    {
        $this->module_key = 'hotels';
        $this->supplier_key = "dotw";
        $this->settings = $this->set_supplier_settings($request);
        $this->dotw_sdk = new DotwSdkController($this->settings);
        $this->supplier_id = get_supplier_id('dotw');
    }
    //========================================================= Main Functions ====================================
    public function set_supplier_settings(Request $request)
    {
        $agent = $request->agent;
        return getSupplierSettings($this->module_key, $this->supplier_key, $agent);
    }

    public function getCurlFunc($params)
    {
        $ch = $this->dotw_sdk->hotelSearchCurlHandle($params);
        return $ch;
    }

    //============================================= Search ================================================================
    public function prepareSearchResults($xmlResponse, $params)
    {
        $this->session_key = generate_session_key();
        $json_res = xml2Array($xmlResponse);
        if (isset($json_res['result']['request']['successful']) && $json_res['result']['request']['successful'] === 'FALSE') {
            $hotelResults = [];
            foreach ($json_res['hotels']['hotel'] as $k => $hotel) {
                $hotel_id = isset($hotel['@attributes']['hotelid']) ? $hotel['@attributes']['hotelid'] : null;
                $hotelInfo = $this->getHotelInfo($hotel);
                $hotelFinance = $this->getHotelFinance($hotel);

                $hotelData = [
                    'SupplierKey' => $this->supplier_id,
                    "SessionId" => $this->session_key,
                    "ResultIndex" => $k,
                    "SupplierCode" => $hotel_id,
                    'Code' => $hotel_id,
                    'HotelWowCode' => $hotel_id . '.' . $this->supplier_id,
                    'CityWowCode' => $params['cityCode'],
                    'Supplier' => [
                        'Name' => 'DOTW',
                        'Session' => $this->session_key,
                        'Code' => $hotel_id,
                    ],
                    'Finance' => $hotelFinance,
                    'Info' => $hotelInfo,
                ];

                $hotelData = array_merge($hotelData, $hotelInfo, $hotelFinance);
                $hotelResults[] = $hotelData;
            }

            return [
                "status" => !empty($hotelResults),
                "message" => !empty($hotelResults) ? 'Hotels found' : 'no hotels found',
                "session_key"    => $this->session_key,
                // "session_id"    => $session->id,
                "data"    => $hotelResults,
            ];
        }
    }
    // ============================================================ Get Hotel Info =====================================
    private function getHotelInfo($id)
    {
        $hotelInfo = [
            'Name' => 'fake name',
            'hotel_name_en' => 'hotel fake name',
            'Address' => 'fake address',
            'hotel_city_wow_code' => $id,
            'hotel_wow_code' => $id,
            'Desc' => 'fake desc',
            'Map' => [
                'Lat' => '30.05227',
                'Long' => '31.24243',
            ],
            'Rating' => 'TwoStar',
            'TripAdvisorRating' => '',
            'Files' => [
                'http://backoffice.gateout.com/uploads/hotels_files/egypt/cairo/1444601//609be8615f827.jpg',
                'http://backoffice.gateout.com/uploads/hotels_files/egypt/cairo/1444601//609be8649ed85.jpg',
                'http://backoffice.gateout.com/uploads/hotels_files/egypt/cairo/1444601//609be8682f585.jpg',
            ],
        ];
        return $hotelInfo;
    }

    private function getHotelFinance($hotel)
    {
        $Finance = [
            'Price' => 34,
            'PriceOld' => 34,
            'Currency' => 'SAR',
        ];
        $rooms = isset($hotel['rooms']) ? $hotel['rooms'] : [];
        $hotelLowestPrice = [];
        // return [count($rooms['room'])];
        if (count($rooms) > 2) {
            foreach ($rooms as $room) {
                $room_types = isset($room['roomType']) ? $room['roomType'] : [];
                if (count($room_types) > 0) {
                    $prices[] = $this->getRoomLowestPrices($room_types);
                }
            }
            $hotelLowestPrice = min($prices);
            $Finance['Price'] = $hotelLowestPrice ? $this->addMarkup($hotelLowestPrice) : 0;
            $Finance['PriceOld'] = $hotelLowestPrice ? round($hotelLowestPrice, 2) : 0;
        }
        return $Finance;
    }

    private function getRoomLowestPrices($roomTypes)
    {
        $lowestPrice = 0;
        foreach ($roomTypes as $type) {
            $prices[] = $type['rateBases']['rateBasis']['total'] ?? 0;
        }
        $lowestPrice = min($prices);
        return $lowestPrice;
    }

    private function addMarkup($price)
    {
        $markup = $this->api->markup;
        $module = $markup->module('hotels');
        $supplier = $markup->supplier('dotw');
        // pre($module, 'module');
        // pre($supplier, 'supplier');
        $price = $markup->add($price, $module, $supplier);
        return round($price, 2);
        // dpre($price);
    }
    //===================================================== Hotel Available Rooms =========================================
    public function available_rooms($session)
    {

        // try {
        $data = [];
        // $data['hotelpage'] = $input['HotelPage'] ?? 1;
        // $hotel_wow_code = $input['HotelWowCode'];

        // $hotel_info = $this->getHotelInfo($hotel_wow_code);
        // $result_index = $input['ResultIndex'];
        // $data['HotelWowCode'] = $hotel_wow_code;
        // $data['CityWowCode'] = $hotel_info['hotel_city_wow_code'];
        // $data['SupplierKey'] = $this->supplier_id;
        // $data["SessionId"] = $this->session_key;

        // $session_data = $this->api->wow_sessions->get_module_session("{$this->session_key}");

        // if (!$session_data) {
        //     return [
        //         'status' => false,
        //         'message' => 'Session Expired!',
        //         'data' => [],
        //     ];
        // }

        // $dotw_session = $session_data['session_key'];
        $params['Id'] = $session->hotel_id;
        $params['Checkout'] = $session->query['Checkout'];
        $params['Checkin'] = $session->query['Checkin'];
        $params['Rooms'] = $session->query['Rooms'];
        $xmlResponse = $this->dotw_sdk->getHotelRooms($params);
        return $xmlResponse;
        $json_res = xml2Array($xmlResponse);
        $this->currency = $json_res['currencyShort'];
        $data['RoomsResultStatus'] = $json_res['successful'];
        if ($data['RoomsResultStatus'] == 'TRUE') {
            $data['HotelResultIndex'] = $json_res['hotel']['@attributes']['id']; //Review
            $RoomsResponse = $json_res['hotel']['rooms'];
            $data['ResultNumber'] = $RoomsResponse['@attributes']['count'];
            $data['OptionsForBookingFixedFormat'] = $json_res['hotel']['allowBook'] == 'yes' ? true : false; //Review

            // set_session('hotels', 'dotw', $this->session_key, [
            //     'OptionsForBookingFixedFormat' => $data['OptionsForBookingFixedFormat'],
            // ]);
            return $RoomsResponse['room'];
            $roomCount = $RoomsResponse['@attributes']['count'];
            if ($roomCount >= 1) {
                $availableRooms = $RoomsResponse['room'];
                return $availableRooms;
                $blocks = [];
                $roomRates = []; // New line
                foreach ($availableRooms as  $roomKey => $room) {
                    foreach ($room['roomType'] as $typeKey => $roomType) {
                        $rates = $roomType['rateBases']['rateBasis'];
                        if (count($rates) > 1) {
                            foreach ($rates as $rate) {
                                $roomRates[$roomKey][] = $this->getRoomRateInfo($roomType, $rate); // New line
                            }
                        } else {
                            $roomRates[$roomKey][] = $this->getRoomRateInfo($roomType, $rates); // New line
                        }
                    }
                    // dj($roomRates);
                }
                return $roomRates;
                // $combinations = $this->getCombinations($roomRates); // New line
                // dj($combinations);
                // die;
                // foreach ($combinations as $combination) { // New line
                //     $roomBlocks = []; // New line
                //     foreach ($combination as $index => $rate) {
                //         $item = $availableRooms[$index]['roomType'][0]; // Updated line
                //         $block = [];
                //         $room = $this->getRoomRateInfo($item, $rate);
                //         $block['Rooms'][] = $room;
                //         $block['BlockPrefCurrency'] = $this->currency;
                //         $block['BlockPrefPrice'] = isset($block['BlockPrefPrice']) ? $block['BlockPrefPrice'] + $room['RoomPrefPrice'] : $room['RoomPrefPrice'];
                //         $block['BlockPrefPriceOld'] = isset($block['BlockPrefPriceOld']) ? $block['BlockPrefPriceOld'] + $room['RoomPrefPrice'] : $room['RoomPrefPrice'];
                //         $roomBlocks[] = $block;
                //     }
                //     // Add all room blocks to the main blocks array
                //     $blocks = array_merge($blocks, $roomBlocks);
                // }
            } else {
                $availableRooms = $RoomsResponse['room']['roomType']; //Review
                $blocks = [];
                foreach ($availableRooms as $item) {
                    if ($item['rateBases']['@attributes']['count'] > 1) {
                        $rateBases = $item['rateBases']['rateBasis'];
                        foreach ($rateBases as $rate) {
                            $block = [];
                            $room = $this->getRoomRateInfo($item, $rate);
                            $block['Rooms'][] = $room;
                            $block['BlockPrefCurrency'] = $this->currency;
                            $block['BlockPrefPrice'] = isset($block['BlockPrefPrice']) ? $block['BlockPrefPrice'] + $room['RoomPrefPrice'] : $room['RoomPrefPrice'];
                            $block['BlockPrefPriceOld'] = isset($block['BlockPrefPriceOld']) ? $block['BlockPrefPriceOld'] + $room['RoomPrefPrice'] : $room['RoomPrefPrice'];
                            $blocks[] = $block;
                        }
                    } else {
                        $block = [];
                        $rate = $item['rateBases']['rateBasis'];
                        $room = $this->getRoomRateInfo($item, $rate);
                        $block['Rooms'][] = $room;
                        $block['BlockPrefCurrency'] = $this->currency;
                        $block['BlockPrefPrice'] = isset($block['BlockPrefPrice']) ? $block['BlockPrefPrice'] + $room['RoomPrefPrice'] : $room['RoomPrefPrice'];
                        $block['BlockPrefPriceOld'] = isset($block['BlockPrefPriceOld']) ? $block['BlockPrefPriceOld'] + $room['RoomPrefPrice'] : $room['RoomPrefPrice'];
                        $blocks[] = $block;
                    }
                }
            }

            $data['Blocks'] = $blocks;
            //store in wow_sessoins
            $session_data['Hotel'] = $data;
            $this->api->wow_sessions->set_session('hotels', 'dotw', $input['WowSessionId'], $session_data);
            return [
                "status" => $data['RoomsResultStatus'] ? true : false,
                // "message" => ,
                "data" => $data ?? [],
            ];
        } else {
            return [
                'status' => false,
                'message' => 'No Rooms',
                'data' => [],
            ];
        }
        // } catch (Exception $e) {
        //     $message = "{$e->getMessage()} on file {$e->getFile()} line {$e->getLine()}";

        //     $this->api->errors_logs->save(__METHOD__, $message, [
        //         'data' => $data,
        //         'session' => $this->api->wow_sessions->get_module_session($this->api->get_session_key()),
        //     ]);

        //     return [
        //         'status' => false,
        //         'message' => $message,
        //     ];
        // }
    }


    private function getCombinations($roomRates)
    {
        $combinations = [[]];
        foreach ($roomRates as $k => $rates) {
            $new_combinations = array();
            foreach ($combinations as $combination) {
                foreach ($rates as $rate) {
                    $new_combinations[] = array_merge($combination, [$rate]);
                }
            }
            $combinations = $new_combinations;
        }
        return $combinations;
    }

    private function getRoomInclusion($item)
    {
        return "Free WiFi";
    }

    private function getRoomRateInfo($item, $rate)
    {
        $room['RoomType'] = $item['name'];
        $room['RoomRate'] = $rate['@attributes']['description'];
        $room['RoomTypeName'] = $item['name'] . ' ' . $rate['@attributes']['description'];
        $room['RoomResultIndex'] = $item['@attributes']['runno'];
        $room['RoomInclusion'] = $this->getRoomInclusion($item);
        $room['RoomTypeCode'] = $item['@attributes']['roomtypecode'];
        $room['allocationDetails'] = $rate['allocationDetails'];
        $room['RoomRatePlanCode'] = $rate['rateType'];
        $room['RoomIsPackageRate'] = null;
        $room['RoomAgentMarkUp'] = '0.00';
        $room['RoomCurrency'] = $this->currency;
        $room['RoomFare'] = '0.00';
        $room['RoomTax'] = '0';
        $room['RoomTotalFare'] = $this->api->amount($this->add_markup($rate['total']));
        $room['RoomPrefPrice'] = $this->api->amount($this->add_markup($rate['total']));
        $room['RoomPrefCurrency'] = $this->currency;

        //Room Day Fare
        $dayRates = $rate['dates']['date'];
        foreach ($dayRates as $dayRate) {
            $day['Date'] = $dayRate['@attributes']['datetime'];
            $day['Fare'] = $this->api->amount($this->add_markup($dayRate['price']));
            $room['DayRates'][] = $day;
        }

        $room['RoomExtraGuestCharges'] = '0.00';
        $room['RoomChildCharges'] = '0.00';
        $room['RoomDiscount'] = '0.00';
        $room['RoomOtherCharges'] = '0.00';
        $room['RoomServiceTax'] = '0.00';

        //Room Amenities & Policy
        $room['RoomAmenities'] = '';
        $room['RoomDefaultPolicy'] = '';

        //Room Cancelation
        $room['RoomLastCancellationDeadline'] = $rate['withinCancellationDeadline'] == 'yes' ? true : false;

        $cancelPolicies = $rate['cancellationRules']['rule'];
        foreach ($cancelPolicies as $k => $cancelPolicy) {
            $policy['FromDate'] = $cancelPolicy['fromDate'] ?? '';
            $policy['ToDate'] = $cancelPolicy['toDate'] ?? '';
            $policy['ChargeType'] = 'amount';
            $policy['CancellationCharge'] = $cancelPolicy['charge'] ?? 0;
            $policy['Currency'] = $this->currency;
            $policy['PrefCurrency'] = $this->currency;
            $policy['PrefCancellationCharge'] = $cancelPolicy['charge'] ?? 0;
            $room['CancelPolicies'][] = $policy;
        }

        //Room Supplements

        // if ($XMLresult->getElementsByTagName("Supplements")->length > 0) {
        //     $supplements = $XMLresult->getElementsByTagName("Supplements")->item(0)->getElementsByTagName("Supplement");
        //     $room['Supplements'] = array();
        //     foreach ($supplements as $supplement) {
        //         $supp['Type'] = $supplement->getAttribute("Type");
        //         $supp['SuppID'] = $supplement->getAttribute("SuppID");
        //         $supp['SuppName'] = $supplement->getAttribute("SuppName");
        //         $supp['SuppIsMandatory'] = $supplement->getAttribute("SuppIsMandatory");
        //         $supp['SuppChargeType'] = $supplement->getAttribute("SuppChargeType");
        //         $supp['Price'] = $supplement->getAttribute("Price");
        //         $supp['CurrencyCode'] = $supplement->getAttribute("CurrencyCode");
        //         array_push($room['Supplements'], $supp);
        //     }
        // }

        return $room;
    }
    private function add_markup($price)
    {
        $markup = $this->api->markup;
        $module = $markup->module('hotels');
        $supplier = $markup->supplier('dotw');
        // pre($module, 'module');
        // pre($supplier, 'supplier');
        $price = $markup->add($price, $module, $supplier);
        return round($price, 2);
        // dpre($price);
    }

    public function pricing($params)
    {
        $data = [];
        try {
            $this->session_key = $params['SupplierSessionId'];
            $room_block = $params['RoomBlock'];
            $room_block_number = count($room_block);
            $hotel_wow_code = $params['HotelCode'];
            $hotel_result_index = $params['ResultIndex'];

            /**
             * * required by markup
             */
            $hotel_info = $this->getHotelInfo($hotel_wow_code);

            $data['HotelWowCode'] = $hotel_wow_code;
            $data['CityWowCode'] = $hotel_info['hotel_city_wow_code'];
            $data['SupplierKey'] = $this->supplier_id;

            $session_data = $this->api->wow_sessions->get_module_session("{$this->session_key}");
            $session_data['hotel_result_index'] = $hotel_result_index;
            // $session_data['hotel_dotw_code'] = $hotel_info['hotel_dotw_code'];
            $session_data['hotel_name_en'] = $hotel_info['hotel_name_en'];

            // if(!isset($session_data['OptionsForBookingFixedFormat']))
            // {
            //     return [
            //         'status' => false,
            //         'message' => 'Session Expired!. Please start over',
            //         'data'  => []
            //     ];
            // }

            // $fixed_format = $session_data['OptionsForBookingFixedFormat'];

            $params['Id'] = $hotel_wow_code;
            $params['Checkout'] = $session_data['Checkout'];
            $params['Checkin'] = $session_data['Checkin'];
            $params['Rooms'] = $session_data['rooms_guests'];

            // foreach ($room_block as $block) {
            $params['SelectedRooms'] = $session_data['Hotel']['Blocks'][$room_block[0]]['Rooms'];
            // }
            $xmlResponse = $this->DOTWconnect->selectedRoomsRequest($params);
            $json_res = $this->xml2Array($xmlResponse);
            $session_data['hotel_name_en'] = $json_res['hotel']['@attributes']['name'];
            $data['ResultStatus'] = $json_res['successful'];
            if ($data['ResultStatus'] == 'TRUE') {
                $data['ResultIndex'] = $session_data['hotel_result_index'];
                $data['AvailableForBook'] = $json_res['hotel']['allowBook'] == 'yes' ? true : false;
                $data['AvailableForConfirmBook'] = $json_res['hotel']['allowBook'] == 'yes' ? true : false;
                // $data['CancellationPoliciesAvailable'] = $doc->getElementsByTagName("CancellationPoliciesAvailable")->item(0)->nodeValue;

                // if ($data['CancellationPoliciesAvailable'] != "false") {
                //     $hotelNorms = $doc->getElementsByTagName("HotelCancellationPolicies")->item(0)->getElementsByTagName("HotelNorms");
                //     $data['NormsString'] = "";
                //     foreach ($hotelNorms as $norm) {
                //         foreach ($norm->getElementsByTagName("string") as $str) {
                //             $data['NormsString'] .= $str->nodeValue . "\n";
                //         }
                //     }

                //     $data['LastCancellationDeadline'] = $doc->getElementsByTagName("HotelCancellationPolicies")->item(0)->getElementsByTagName("CancelPolicies")->item(0)->getElementsByTagName("LastCancellationDeadline")->item(0)->nodeValue;
                //     $data['DefaultPolicy'] = $doc->getElementsByTagName("HotelCancellationPolicies")->item(0)->getElementsByTagName("CancelPolicies")->item(0)->getElementsByTagName("DefaultPolicy")->item(0)->nodeValue;
                //     $data['AutoCancellationText'] = $doc->getElementsByTagName("HotelCancellationPolicies")->item(0)->getElementsByTagName("CancelPolicies")->item(0)->getElementsByTagName("AutoCancellationText")->item(0)->nodeValue;

                //     $cancelPolicies = $doc->getElementsByTagName("HotelCancellationPolicies")->item(0)->getElementsByTagName("CancelPolicies")->item(0)->getElementsByTagName("CancelPolicy");
                //     $data['CancelPolicies'] = array();
                //     $confirmed_booking = false;
                //     foreach ($cancelPolicies as $cancelPolicy) {
                //         $policy['FromDate'] = $cancelPolicy->getAttribute("FromDate");
                //         $policy['ToDate'] = $cancelPolicy->getAttribute("ToDate");
                //         $policy['ChargeType'] = $cancelPolicy->getAttribute("ChargeType");
                //         $policy['CancellationCharge'] = $cancelPolicy->getAttribute("CancellationCharge");
                //         $policy['Currency'] = $cancelPolicy->getAttribute("Currency");
                //         $policy['PrefCurrency'] = $cancelPolicy->getAttribute("PrefCurrency");
                //         if ($policy['ChargeType'] == "Fixed") {
                //             $policy['PrefCancellationCharge'] = $cancelPolicy->getAttribute("PrefCancellationCharge");
                //             if ((int) ($policy['PrefCancellationCharge']) == 0) {
                //                 $confirmed_booking = true;
                //             }
                //         }
                //         array_push($data['CancelPolicies'], $policy);
                //     }
                // }

                // $data['PriceChanged'] = $doc->getElementsByTagName("PriceVerification")->item(0)->getAttribute("PriceChanged");
                // $data['AvailableOnNewPrice'] = $doc->getElementsByTagName("PriceVerification")->item(0)->getAttribute("AvailableOnNewPrice");

                // $data['AgencyBalance'] = $doc->getElementsByTagName("AccountInfo")->item(0)->getAttribute("AgencyBalance");
                // $data['AgencyBlocked'] = $doc->getElementsByTagName("AccountInfo")->item(0)->getAttribute("AgencyBlocked");

                $data['HotelName'] = $json_res['hotel']['@attributes']['name'];
                // $data['HotelRating'] = $doc->getElementsByTagName("HotelDetails")->item(0)->getAttribute("HotelRating");
                $data['HotelAddress'] = "";
                // if ($doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("Address")->length > 0) {
                //     $data['HotelAddress'] = $doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("Address")->item(0)->nodeValue;
                // }

                // if ($doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("FaxNumber")->length > 0) {
                //     $data['HotelFaxNumber'] = $doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("FaxNumber")->item(0)->nodeValue;
                // }
                // if ($doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("PhoneNumber")->length > 0) {
                // $data['HotelPhoneNumber'] = $doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("PhoneNumber")->item(0)->nodeValue;
                // }
                $data['HotelMap']['Lat'] = "";
                $data['HotelMap']['Long'] = "";
                // if ($doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("Map")->length > 0) {
                //     $hotel_map = $doc->getElementsByTagName("HotelDetails")->item(0)->getElementsByTagName("Map")->item(0)->nodeValue;
                //     $hotel_map_array = explode('|', $hotel_map);
                //     if ($hotel_map[0]) {
                //         $data['HotelMap']['Lat'] = $hotel_map_array[0];
                //     }
                //     if ($hotel_map[1]) {
                //         $data['HotelMap']['Long'] = $hotel_map_array[1];
                //     }
                // }

                $session_data['BookingInfo'] = [
                    'HotelName' => $data['HotelName'],
                    'AvailableForBook' => $data['AvailableForBook'],
                    'AvailableForConfirmBook' => $data['AvailableForConfirmBook'],
                    'HotelAddress' => $data['HotelAddress'],
                ];


                $data['RoomsGuests'] = $session_data['rooms_guests'];

                foreach ($data['RoomsGuests'] as $key => $row) {
                    if (!isset($row['children_ages'])) {
                        $data['RoomsGuests'][$key]['children_ages'] = [];
                    }
                }

                $hotel_rooms = $json_res['hotel']['rooms'];

                $data['HotelRooms'] = [];

                if ($room_block_number == 1) {
                    $data['HotelRooms'][0] = $hotel_rooms;
                } else {
                    $data['HotelRooms'] = $hotel_rooms;
                }


                $data['Rooms'] = [];
                $total_price = 0;

                foreach ($data['HotelRooms'] as $room) {
                    $roomTypes = $room['room']['roomType'];
                    foreach ($roomTypes as $roomType) {
                        foreach ($params['SelectedRooms'] as $selectedRoom) {
                            if ($roomType['name'] !== $selectedRoom['RoomType']) {
                                continue;
                            }

                            $rateBases = $roomType['rateBases']['rateBasis'];
                            $count = $roomType['rateBases']['@attributes']['count'];
                            if ($count > 1) {
                                foreach ($rateBases as $rate) {
                                    if ($selectedRoom['RoomRate'] !== $rate['@attributes']['description']) {
                                        continue;
                                    }

                                    $roomInfo = $this->getRoomRateInfo($roomType, $rate);
                                    $roomInfo['Rate'] = [
                                        'PrefPrice' => $rate['total'],
                                        'PrefCurrency' => 'SAR',
                                    ];
                                    $data['Rooms'][] = $roomInfo;
                                    $total_price += $rate['total'];
                                }
                            } else {
                                $rate = $rateBases;
                                if ($selectedRoom['RoomRate'] !== $rate['@attributes']['description']) {
                                    continue;
                                }

                                $roomInfo = $this->getRoomRateInfo($roomType, $rate);
                                $roomInfo['Rate'] = [
                                    'PrefPrice' => $rate['total'],
                                    'PrefCurrency' => 'SAR',
                                ];
                                $data['Rooms'][] = $roomInfo;
                                $total_price += $rate['total'];
                            }
                        }
                    }
                }
                /**
                 * add markup (commission)
                 */
                $total_price = $this->api->amount($total_price);
                $data['TotalOriginalPrefPrice'] = $total_price;

                $markup_price = $this->add_markup($total_price);
                $markup_amount = $markup_price - $total_price;
                $room_markup_amount = $markup_amount / count($data['HotelRooms']);

                $data['TotalPrefPrice'] = $this->api->amount($markup_price);
                $data['PrefCurrency'] = 'SAR';
                foreach ($data['Rooms'] as $k => &$room) {
                    $room['Rate'] = [
                        'PrefPrice' => $room['Rate']['PrefPrice'] + $room_markup_amount,
                        'PrefCurrency' => 'SAR',
                    ];
                    unset($room['RoomRate']);
                    $room['RoomRate']['@attributes']['PrefPrice'] = $room['Rate']['PrefPrice'];
                }
                // !TODO
                // unset($data['HotelRooms']);
                $session_data['Finance'] = [
                    'OriginalAmount' => $data['TotalOriginalPrefPrice'],
                    'Amount' => $markup_price,
                    'CurrencyCode' => $data['PrefCurrency'],
                ];
                $session_data['selected_rooms'] = $data['Rooms'];

                $this->api->wow_sessions->set_session('hotels', 'dotw', $this->session_key, $session_data);

                //if availableforbook = true && availableforconfirmbook = true
                //then the client can pay later and we can make confirmed booking instead of vouchered booking
                if ($data['AvailableForBook'] == true && $data['AvailableForConfirmBook'] == true) {
                    //confirmed booking can be made
                } else if ($data['AvailableForBook'] == "true" && $data['AvailableForConfirmBook'] == "false") {
                    // vouchered booking can be made
                } else {
                    //die("Booking Unavailable");
                }
                $data['HotelRooms'] = $data['Rooms'];
                unset($data['Rooms']);
                return [
                    "status" => true,
                    "message" => $json_res['successful'],
                    "data" => $data,
                ];
            } else {
                return [
                    "status" => false,
                    "message" => $json_res['successful'],
                    "data" => [],
                ];
            }
        } catch (Exception $e) {
            $message = "{$e->getMessage()} on file {$e->getFile()} line {$e->getLine()}";

            $this->api->errors_logs->save(__METHOD__, $message, [
                'data' => $data,
                'session' => $this->api->wow_sessions->get_module_session($this->api->get_session_key()),
            ]);

            return [
                'status' => false,
                'message' => $message,
                'data' => [],
            ];
        }
    }
    //===================================================== Hotel Booking =================================================
    public function booking($params)
    {
        // $this->api->response([
        //     'status' => false,
        //     'message' => 'Session Expired',
        //     'data' =>$params,
        // ]);
        // var_dump($params);
        // die;

        $this->api->load->library(['markup']);
        try {
            $data = [];

            $lead_guest = $params['LeadGuest'];
            $rooms_guests = $params['RoomsGuests'];
            $user_credits = $params['UserCredits'];
            $wow_session = $params['WowSession'];
            $this->session_key = $wow_session['session_key'];
            $selected_rooms = $wow_session['Hotel']['rooms'];
            $this->api->response([
                'status' => false,
                'message' => 'Session Expired',
                'data' => $wow_session,
            ]);
            die;
            $hotel_result_index = $wow_session['hotel_result_index'];
            $hotel_id = $wow_session['Hotel']['HotelWowCode'];
            // $hotel_name_en = $wow_session['hotel_name_en'];
            $total_price = $wow_session['Finance']['Amount'];

            $current_date = date("dmyHms") . "000";

            $alphabet_string = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';

            $random_string = substr(str_shuffle($alphabet_string), 0, 4);
            //echo $str_result;
            $client_reference_number = $current_date . "#" . $random_string;
            $nationality = $this->api->get_country_code();
            //======== Check Payment
            //20,000 30,000
            //-10000
            $user_net_amount = $user_credits->credit_amount - $total_price;
            $available_for_pay = false;
            // $confirmed_booking = TRUE;

            if ($user_net_amount >= $user_credits->credit_allowed_amount) {
                $available_for_pay = true;
                // $confirmed_booking = FALSE;
                //=======
            }

            $wow_session['booking_needed_details'] = [
                'client_ref' => $client_reference_number,
                'nationality' => $nationality,
                'session_key' => $this->session_key,
                'hotel_result_index' => $hotel_result_index,
                'hotel_dotw_code' => $hotel_dotw_code,
                'hotel_name_en' => $hotel_name_en,
                'selected_rooms' => $selected_rooms,
                'lead_guest' => $lead_guest,
                'rooms_guests' => $rooms_guests,
            ];

            $amount_to_pay = $total_price;

            // !convert payment currency to sar
            $amount_to_pay = payment_currency($amount_to_pay, $params['CurrencyCode'], 'SAR');
            $amount_to_pay = $this->add_markup($amount_to_pay);

            $booking_data = [];
            /**
             * todo check if pay later is ticked in front end
             */
            if ($wow_session['BookingInfo']['AvailableForBook'] === 'true' && $wow_session['BookingInfo']['AvailableForConfirmBook'] === 'true') {
                $confirmed_booking = true;
                // $xmlResponse = $this->dotwholidays->bookHotelmeth($client_reference_number, $nationality,
                // $this->session_key, $hotel_result_index, $hotel_dotw_code, $hotel_name_en, $selected_rooms,
                // $lead_guest, $rooms_guests, $confirmed_booking);
                $booking = new Booking($this->dotwholidays);
                $booking_request = $booking->confirmed_booking(
                    $client_reference_number,
                    $nationality,
                    $this->session_key,
                    $hotel_result_index,
                    $hotel_dotw_code,
                    $hotel_name_en,
                    $selected_rooms,
                    $lead_guest,
                    $rooms_guests
                );

                $data = $booking->booking_details($client_reference_number)['data'];
                $data['confirmation_number'] = $booking_request['confirmation_number'];

                $booking_data = array(
                    'user_id' => $params['UserId'],
                    'company_id' => $params['Company']->id,
                    'supplier' => 'dotw',
                    'supplier_booking_id' => $data['BookingId'],
                    'dotw_booking_id' => $data['BookingId'],
                    'amendment_status' => $data['AmendmentStatus'],
                    'confirmation_number' => $data['ConfirmationNo'],
                    'invoice_number' => $data['InvoiceNumber'],
                    'supplier_ref_number' => $data['SupplierReferenceNo'],
                    'trip_name' => $data['TripName'],
                    'requested_client_ref_number' => $client_reference_number,
                    'booking_description' => $data['BookingDesc'],
                    'booking_status' => $data['BookingStatus'],
                    'voucher_status' => $data['VoucherStatus'],
                    'hotel_name' => $hotel_name_en,
                    'hotel_rating' => $data['Rating'],
                    'hotel_id' => $hotel_id,
                    'city_code' => $data['CityId'],
                    'city_name' => $data['City'],
                    'from_date' => $data['CheckInDate'],
                    'to_date' => $data['CheckOutDate'],
                    'last_cancellation_deadline' => $data['LastCancellationDeadline'],
                    'current_cancellation_charge' => $data['CurrentCancellationCharges'],
                    'rooms_number' => $data['NoOfRooms'],
                    'rooms_type_name' => $data['roomsname'],
                    'currency_code' => $wow_session['Finance']['CurrencyCode'],
                    'original_amount' => $wow_session['Finance']['OriginalAmount'],
                    'amount' => $wow_session['Finance']['Amount'],
                    'booking_date' => $data['BookingDate'],
                    'booking_details' => json_encode($wow_session),
                );
            } elseif ($wow_session['BookingInfo']['AvailableForBook'] === 'true' && $wow_session['BookingInfo']['AvailableForConfirmBook'] === 'false') {
                $booking_data = array(
                    'user_id' => $params['UserId'],
                    'company_id' => $params['Company']->id,
                    'supplier' => 'dotw',
                    'requested_client_ref_number' => $client_reference_number,
                    'booking_status' => 'false',
                    'voucher_status' => 'pending',
                    'hotel_name' => $hotel_name_en,
                    'hotel_id' => $hotel_id,
                    'from_date' => $wow_session['Checkin'],
                    'to_date' => $wow_session['Checkout'],
                    'currency_code' => $wow_session['Finance']['CurrencyCode'],
                    'original_amount' => $wow_session['Finance']['OriginalAmount'],
                    'amount' => $wow_session['Finance']['Amount'],
                    'confirmation_number' => 'false',
                    'booking_details' => json_encode($wow_session),
                );
            }
            if (!$booking_data) {
                return [
                    'status' => false,
                    'message' => 'Session expired or not available for book now. Try again',
                    'data' => [],
                ];
            }

            $this->api->db->insert('hotels_booking_list', $booking_data);
            $booking_id = $this->api->db->insert_id();

            //Payment prepare ============================================
            // $data['MerchantRef'] = $params['UserId'] . "_" . $bookinsert_id;
            $short_merchant_ref = implode('.', [$booking_id, $params['UserId']]);
            $data['MerchantRef'] = implode('.', ['hotels', 'dotw', $booking_id, $params['UserId']]);
            $data['UserId'] = $params['UserId'];

            $data['amount_to_pay'] = $amount_to_pay;

            /* if ($wow_session['AvailableForBook'] == TRUE && $wow_session['AvailableForConfirmBook'] == FALSE)
             {
             $this->api->db->insert('payment_transactions', [
             'merchant_ref'    => $data['MerchantRef'],
             'user_id'        => $params['UserId'],
             'amount'        => $amount_to_pay
             ]);
             } */

            // transaction table
            $this->api->db
                ->insert('payment_transactions', [
                    'module' => 'hotels',
                    // 'supplier_name' =>  'dotw',
                    'merchant_ref' => $data['MerchantRef'],
                    'user_id' => $params['UserId'],
                    'currency' => 'SAR', // ! $params['CurrencyCode'], we can get this from settings in future $settings['PaymentCurrencyCode']
                    'amount' => $amount_to_pay,
                    'status' => 'pending',
                    'payment_option' => 'balance', // todo change according to b2c or b2b
                ]);

            // !!! important
            // foreach($data['RoomsDetails'] as $room)
            // {
            //     foreach($room['Guests'] as $guest)
            //     {
            //         $guestsData = array(
            //             'booking_id' => $booking_id,
            //             'guest_title' => $guest['Title'],
            //             'guest_first_name' => $guest['FirstName'],
            //             'guest_last_name' => $guest['LastName'],
            //             'guest_age' => $guest['Age'],
            //             'guest_lead' => $guest['LeadGuest'],
            //             'guest_type' => $guest['GuestType']
            //         );
            //         $this->api->db->insert('guest_list', $guestsData);
            //     }
            // }

            // return [
            //     "status" => $data['ResultStatus'] == '01' ? TRUE : FALSE,
            //     "message" => $data['BookingDesc'],
            //     "data"    => $data,
            // ];
            return [
                'status' => $data['MerchantRef'] ? true : false,
                'message' => isset($data['BookingDesc']) ? $data['BookingDesc'] : 'Dummy booking created',
                'data' => [
                    'MerchantRef' => $short_merchant_ref,
                ],
            ];
        } catch (Exception $e) {
            $message = "{$e->getMessage()} on file {$e->getFile()} line {$e->getLine()}";

            $this->api->errors_logs->save(__METHOD__, $message, [
                'data' => $data,
                'session' => $this->api->wow_sessions->get_module_session($this->api->get_session_key()),
            ]);

            // $this->response( [
            //     'status' => false,
            //     'message' => $message,
            //     'data'  => []
            // ], REST_Controller::HTTP_INTERNAL_SERVER_ERROR );
            return [
                'status' => false,
                'message' => $message,
                'data' => [],
            ];
        }
    }
}
