<?php

namespace Modules\Payments\Tests\Unit;

use Tests\TestCase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\RefreshDatabase;

class PaymentsControllerTest extends TestCase
{
    public $merchantRef = "hotels.75.164";
    public $supplierKey = "paymob";
    public function testTokenize()
    {
        $headers = [
            'Authorization' => 'Bearer e2fe3b8b-9841-4692-96f6-ad0154e00cf5',
            'x-language-code' => 'en',
            'x-country-code' => 'us',
            'x-currency-code' => 'usd',
            'X-Client-Ip' => '127.0.0.1',
        ];
        $requestData = [
            "supplier_key" => $this->merchantRef,
            "merchant_ref" => $this->supplierKey
        ];

        $uri = action('Modules\Hotels\Http\Controllers\HotelsController@booking');
        $paymentResponse = $this->post($uri, $requestData, $headers);
        $responseData = json_decode($paymentResponse->content(), true);
        $this->assertTrue($responseData['status']);
    }
}
