<?php

namespace Modules\StaticData\Entities;

use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class City extends Model
{
    use HasFactory, Translatable;

    protected $table = 'cities';

    protected $fillable = [
        'country_id',
        'country_code',
        'state_id',
        'state_code',
        'lat',
        'lng',
        'flag',
        'wikidataid',
    ];

    public $translatedAttributes = [
        'name',
        'description'
    ];

    protected $appends = ['supplier_code', 'city_country'];

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function getCityCountryAttribute()
    {
        $country = $this->country;
        return $country ?? null;
    }

    public function getCitySupplierCode($supplier_id)
    {
        $supplier = $this->hasOne(SupplierCity::class, 'city_id')->where('supplier_id', $supplier_id)->first();
        if ($supplier) {
            return $supplier->code;
        }
        return null;
    }

    public function hotels()
    {
        return $this->hasMany(Hotel::class);
    }
    
    public function airports()
    {
        return $this->hasMany(Airport::class);
    }

    public function supplierCodes()
    {
        return $this->hasMany(SupplierCity::class);
    }

    public function getSupplierCodeAttribute()
    {
        return $this->supplierCodes->pluck('code', 'supplier_id')->unique()->all();
    }
}
