{{-- Extends layout --}}
@extends('admin.layout.default')
@push('style')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.5.1/min/dropzone.min.css" rel="stylesheet" />
@endpush
{{-- Content --}}
@section('content')
    <div class="container-fluid">
        <div class="row page-titles mx-0 mb-3">
            <div class="col-sm-6 p-0">
                <div class="welcome-text">
                    <h4>{{ __('countries') }}</h4>
                    <span>{{ __('Add country') }}</span>
                </div>
            </div>
            <div class="col-sm-6 p-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('static_data.countries.index') }}">{{ __('countries') }}</a>
                    </li>
                    <li class="breadcrumb-item active"><a href="javascript:void(0)">{{ __('Add Country') }}</a></li>
                </ol>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">{{ __('Add Country') }}</h4>
            </div>
            <form action="{{ route('static_data.countries.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card-body">
                    <div class="basic-form">
                        <div class="row align-items-center" style="margin-bottom:32px">
                            <div class="col-sm-2 text-center">
                                <div class="custom-img-upload img-parent-box">
                                    <img src="{{ asset('images/noimage.jpg') }}" class="avatar mb-1 img-for-onchange"
                                        id="CountryImg" alt="{{ __('Image') }}" width="100px" height="100px"
                                        title="{{ __('Image') }}">
                                    <div class="upload-btn">
                                        <input type="file" class="form-control ps-2 img-input-onchange"
                                            name="country_img" id="country_img" accept=".png, .jpg, .jpeg" hidden>
                                        <label class="upload-label btn btn-xs btn-primary m-0"
                                            for="country_img">{{ __('Upload') }}</label>
                                    </div>
                                </div>
                                @error('country_img')
                                    <p class="text-danger">
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>
                            <div class="col-sm-2 text-center">
                                <div class="custom-img-upload img-parent-box">
                                    <img src="{{ asset('images/noimage.jpg') }}" class="avatar mb-1 img-for-onchange"
                                        id="CountryImg" alt="{{ __('Image') }}" width="100px" height="100px"
                                        title="{{ __('Image') }}">
                                    <div class="upload-btn">
                                        <input type="file" class="form-control ps-2 img-input-onchange"
                                            name="country_img" id="country_img" accept=".png, .jpg, .jpeg" hidden>
                                        <label class="upload-label btn btn-xs btn-primary m-0"
                                            for="country_img">{{ __('Upload') }}</label>
                                    </div>
                                </div>
                                @error('country_img')
                                    <p class="text-danger">
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>

                            <div class="col-sm-2 text-center">
                                <div class="custom-img-upload img-parent-box">
                                    <img src="{{ asset('images/noimage.jpg') }}" class="avatar mb-1 img-for-onchange"
                                        id="CountryImg" alt="{{ __('Image') }}" width="100px" height="100px"
                                        title="{{ __('Image') }}">
                                    <div class="upload-btn">
                                        <input type="file" class="form-control ps-2 img-input-onchange" name="gallery[]"
                                            id="country_img" accept=".png, .jpg, .jpeg" hidden multiple>
                                        <label class="upload-label btn btn-xs btn-primary m-0"
                                            for="country_img">{{ __('Upload') }}</label>
                                    </div>
                                </div>
                                @error('gallery')
                                    <p class="text-danger">
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>
                        </div>
                        <div class="row align-items-center">
                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label>{{ __('Name Ar') }}</label>
                                        <input type="text" name="name_ar" id="name_ar" class="form-control"
                                            autocomplete="name_ar" value="{{ old('name_ar') }}">
                                        @error('first_name')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>{{ __('Name En') }}</label>
                                        <input type="text" name="name_en" id="name_en" class="form-control"
                                            value="{{ old('name_en') }}">
                                        @error('name_en')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-6">
                                        <label>{{ __('Code') }}</label>
                                        <input type="text" name="code" id="code" class="form-control"
                                            value="{{ old('code') }}">
                                        @error('code')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-6">
                                        <label>{{ __('Phone Code') }}</label>
                                        <input type="number" name="phone_code" id="phone_code" class="form-control"
                                            value="{{ old('phone_code') }}">
                                        @error('phone_code')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-6">
                                        <label>{{ __('Nationality Ar') }}</label>
                                        <input type="text" name="nationality_ar" id="nationality_ar"
                                            class="form-control" value="{{ old('nationality_ar') }}">
                                        @error('nationality_ar')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-6">
                                        <label>{{ __('Nationality En') }}</label>
                                        <input type="text" name="nationality_en" id="nationality_en"
                                            class="form-control" value="{{ old('nationality_en') }}">
                                        @error('nationality_en')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-6">
                                        <label>{{ __('Iso3 Code') }}</label>
                                        <input type="text" name="iso3_code" id="iso3_code" class="form-control"
                                            value="{{ old('iso3_code') }}">
                                        @error('iso3_code')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-6">
                                        <label>{{ __('Currency') }}</label>
                                        <input type="text" name="currency" id="currency" class="form-control"
                                            value="{{ old('currency') }}">
                                        @error('currency')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>

                                    <div class="form-group col-6">
                                        <label>{{ __('region') }}</label>
                                        <input type="text" name="region" id="region" class="form-control"
                                            value="{{ old('region') }}">
                                        @error('region')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>

                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12">
                                    <textarea name="desc_ar" class="form-control wowwsCkeditor h-auto" id="DescAR" rows="10">{{ old('data.Page.content') }}</textarea>
                                    @error('desc_ar')
                                        <p class="text-danger">
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12">
                                    <textarea name="desc_en" class="form-control wowwsCkeditor h-auto" id="Desc_EN" rows="10">{{ old('data.Page.content') }}</textarea>
                                    @error('desc_en')
                                        <p class="text-danger">
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                            <a href="{{ route('static_data.countries.index') }}"
                                class="btn btn-danger">{{ __('Back') }}</a>
                        </div>
            </form>
        </div>

    </div>

@endsection
