<?php

use App\Models\WowSession;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Modules\StaticData\Entities\SupplierHotel;

function get_hotel_by_tbo_code($id, $code)
{
    $hotel_supplier = SupplierHotel::where('supplier_id', $id)->where('code', $code)->first();
    if ($hotel_supplier) {
        $hotel = $hotel_supplier->hotel;
        return $hotel ?? null;
    }
    return null;
}

function get_hotel_session_data($request)
{
    $validator = Validator::make($request->all(), [
        'session_id' => 'required',
        'hid' => 'required',
    ]);

    if ($validator->fails()) {
        $errorString = implode(', ', $validator->errors()->all());
        throw new Exception('Validation Error: ' . $errorString);
    }
    
    $hotel_full = explode('-', $request->hid);
    $hotel_id = $hotel_full[0];
    $result_index = $hotel_full[1];
    $session_key = isset($request->session_id) ? $request->session_id : '';
    $session = WowSession::where('key', $session_key)->first();
    if (!$session) {
        throw new Exception('Session Invalid or Expired');
    }
    return ['result_index' => $result_index, 'hotel_id' => $hotel_id, 'session' => $session];
}
