<?php

use App\Models\Customer;
use App\Models\Logs;
use App\Models\User;
use App\Models\WowSession;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Modules\StaticData\Entities\Country;

//user Data 
function getUserData($id)
{
    $user = User::with('balance')->where('id', $id)->first();
    return $user;
}

function getNationality($country)
{
    $country = Country::where('code', $country)->first();
    return optional($country->Nationality->translate('en'))->name ?? '';
}

//supplier list
function getSupplierList($module_key, $user)
{
    $userSuppliersWithInfo = $user->suppliers()
        ->with([
            'supplier' => function ($query) {
                $query->select('id', 'key'); // Select the attributes you want from the supplier
            },
            'module' => function ($query) use ($module_key) {
                $query->select('id', 'key')->where('key', $module_key); // Select the attributes you want from the module
            }
        ])
        ->whereHas('module', function ($query) use ($module_key) {
            $query->where('key', $module_key);
        })
        ->get();

    $supplier_keys = $userSuppliersWithInfo->map(function ($userSupplier) {
        return $userSupplier->supplier;
    })->toArray(); // Convert the collection to an array

    return $supplier_keys;
}


function getSupplierSettings($module_key, $supplier_key, $user)
{
    $settings = $user->suppliers()
        ->with([
            'supplier' => function ($query) use ($supplier_key) {
                $query->select('id', 'key')->where('key', $supplier_key); // Select the attributes you want from the supplier
            },
            'module' => function ($query) use ($module_key) {
                $query->select('id', 'key')->where('key', $module_key); // Select the attributes you want from the module
            }
        ])
        ->whereHas('module', function ($query) use ($module_key) {
            $query->where('key', $module_key);
        })
        ->whereHas('supplier', function ($query) use ($supplier_key) {
            $query->where('key', $supplier_key);
        })
        ->first();

    return $settings['supplier_settings'];
}

//supplier loading
function load_supplier($supplier, $module)
{
    $supplierControllerName = '\\Modules\\' . ucfirst($module) . '\\Http\\Controllers\\' . ucfirst($supplier) . 'Controller';
    if (class_exists($supplierControllerName)) {
        $supplierClass = new $supplierControllerName(request());
        return $supplierClass;
    }
}

function load_suppliers(array $suppliers, $module)
{
    $suppliersObjects = [];
    foreach ($suppliers as $key => $supplier) {
        $supplierClass = load_supplier($supplier['key'], $module);
        if ($supplierClass) {
            $suppliersObjects[$supplier['key']] = $supplierClass;
        }
    }
    return $suppliersObjects;
}

function createOrUpdateUser($lead_guest, $module_key)
{
    $user_data = [
        'email' => $lead_guest['email'],
        'phone' => $lead_guest['mobile']['full_number'] ?? $lead_guest['mobile'],
        'first_name' => $lead_guest['first_name'],
        'last_name' => $lead_guest['last_name'],
        'title' => $lead_guest['title'],
        'module' => $module_key,
        'company_id' => request()->agent->id,
    ];

    $user = Customer::updateOrcreate(
        ['email' => $user_data['email'], 'company_id' => $user_data['company_id'], 'module' => $user_data['module']],
        $user_data
    );
    
    return $user;
}
