<?php

namespace App\Http\Controllers;

use App\Models\MappedHotels;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use DOMDocument;
use GuzzleHttp\Client;
use Modules\StaticData\Entities\Airport;
use Modules\StaticData\Entities\City;
use Modules\StaticData\Entities\CityTranslation;
use Modules\StaticData\Entities\Country;
use Modules\StaticData\Entities\CountryTranslation;
use Modules\StaticData\Entities\Hotel;
use Modules\StaticData\Entities\HotelFacility;
use Modules\StaticData\Entities\HotelFacilityTranslation;
use Modules\StaticData\Entities\Nationality;
use Modules\StaticData\Entities\SupplierCity;
use Modules\StaticData\Entities\SupplierHotel;

class HotelMappingController extends Controller
{
    // $all_hotels = DB::table('hotel_list')->get();
    // $beds_hotels = DB::connection('old_backoffice')->table('wow_beds_hotels')->get();
    // $mapped = [];

    // foreach ($all_hotels as $hotel) {
    //     foreach ($beds_hotels as $bed_hotel) {
    //         if (str_contains($hotel->name_en, $bed_hotel->name_en)) {
    //             $mapped[] = [
    //                 'beds' => $bed_hotel,
    //                 'all' => $hotel,
    //             ];
    //             break; // Exit the inner loop once a match is found
    //         }
    //     }
    // }

    // return $mapped;
    // public function hotel_mapping()
    // {
    //     $all_hotels = DB::table('hotel_list')->get();
    //     $beds_hotels = DB::connection('old_backoffice')->table('wow_beds_hotels')->get();
    //     $mapped = [];
    //     foreach ($all_hotels as $hotel) {
    //         foreach ($beds_hotels as $bed_hotel) {
    //             if ($hotel->name_en === $bed_hotel->name_en) {
    //                 $mapped[]['beds'] = $bed_hotel;
    //                 $mapped[]['all'] = $hotel;
    //             }
    //         }
    //         // MappedHotels::updateOrCreate(
    //         //     [
    //         //         'wow_code' => $hotel->wow_code,
    //         //         'country_code' => $hotel->country_code,
    //         //     ],
    //         //     [
    //         //         //tbo hotel codes
    //         //         // 'country_tbo_code' => $hotel->country_code,
    //         //         // 'city_tbo_code' => $hotel->city_tbo_code,
    //         //         // 'hotel_tbo_code' => $hotel->tbo_code,
    //         //         //beds hote codes
    //         //         'country_tbo_code' => $hotel->country_code,
    //         //         'city_tbo_code' => $hotel->city_tbo_code,
    //         //         'hotel_tbo_code' => $hotel->tbo_code,
    //         //     ]
    //         // );
    //     }
    //     return $mapped;
    // }



    public function map()
    {
        // return $this->get_beds_cities();
        // return $this->get_beds_countries();
        // return $this->get_country_cities();
        // $username = 'alzuhitest';
        // $password = 'Reh@49840647';

        // $soap_request = '
        //     <soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:hot="http://TekTravel/HotelBookingApi">
        //         <soap:Header xmlns:wsa="http://www.w3.org/2005/08/addressing">
        //             <hot:Credentials UserName="' . $username . '" Password="' . $password . '"></hot:Credentials>
        //             <wsa:Action>http://TekTravel/HotelBookingApi/CountryList</wsa:Action>
        //             <wsa:To>https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc</wsa:To>
        //         </soap:Header>
        //         <soap:Body>
        //             <hot:CountryList></hot:CountryList>
        //         </soap:Body>
        //     </soap:Envelope>
        // ';

        // $wsdl = "https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc?WSDL";
        // $response = Http::withHeaders([
        //     'Content-Type' => 'application/soap+xml; charset=utf-8',
        //     'SOAPAction' => 'run',
        //     'Accept' => 'text/xml',
        //     'Cache-Control' => 'no-cache',
        //     'Pragma' => 'no-cache',
        //     'Content-length' => strlen($soap_request),
        //     'User-Agent' => 'PHP-SOAP/7.0.10',
        //     'Accept-Encoding' => 'gzip, deflate',
        // ])->withOptions([
        //     'verify' => false,
        // ])->withBasicAuth($username, $password)->post($wsdl, $soap_request);

        // $response = $response->body();
        // return $response;


        $username = 'alzuhitest';
        $password = 'Reh@49840647';

        $soap_request = '
            <soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:hot="http://TekTravel/HotelBookingApi">
                <soap:Header xmlns:wsa="http://www.w3.org/2005/08/addressing">
                    <hot:Credentials UserName="' . $username . '" Password="' . $password . '"></hot:Credentials>
                    <wsa:Action>http://TekTravel/HotelBookingApi/CountryList</wsa:Action>
                    <wsa:To>https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc</wsa:To>
                </soap:Header>
                <soap:Body>
                    <hot:CountryListRequest></hot:CountryListRequest>
                    <hot:Language>AR</hot:Language>
                    </soap:Body>
            </soap:Envelope>
        ';

        $wsdl = "https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc?WSDL";

        $client = new Client();

        $response = $client->request('POST', $wsdl, [
            'headers' => [
                'Content-Type' => 'application/soap+xml; charset=utf-8',
                'SOAPAction' => 'run',
                'Accept' => 'text/xml',
                'Cache-Control' => 'no-cache',
                'Pragma' => 'no-cache',
                'Content-length' => strlen($soap_request),
                'User-Agent' => 'PHP-SOAP/7.0.10',
                'Accept-Encoding' => 'gzip, deflate',
            ],
            'verify' => false,
            'auth' => [$username, $password],
            'body' => $soap_request,
        ]);

        $response = $response->getBody()->getContents();
        // return $response;
        $doc = new DOMDocument('1.0', 'utf-8');
        $doc->loadXML($response);
        $XMLresults = $doc->getElementsByTagName("Country");
        // Assuming you have a "logs" table and a "country_list" table

        // First check the "logs" table whether TBO country is done or not
        // Search for "country_tbo_done" with value 1
        // $logs = \DB::table('logs')->where(['name' => 'country_tbo_updated', 'value' => '1'])->first();

        foreach ($XMLresults as $XMLresult) {
            $countryName = $XMLresult->getAttribute('CountryName');
            $countryCode = $XMLresult->getAttribute('CountryCode');
            // // Insert the country into the "country_list" table
            // $data = [
            //     'country_name' => $countryName,
            //     'country_code' => $countryCode,
            // ];
            // DB::table('tbo_countries')->insert($data);
            $this->get_country_cities();
        }

        // Update the "logs" table
        $data = [
            'name' => 'country_tbo_updated',
            'value' => '1',
        ];
    }


    public function get_country_cities()
    {
        ini_set('max_execution_time', '0');
        $username = 'alzuhitest';
        $password = 'Reh@49840647';
        $countries = DB::table('tbo_countries')->where('updated', 0)->get();
        foreach ($countries as $country) {

            $soap_request = '
                    <soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:hot="http://TekTravel/HotelBookingApi">
                        <soap:Header xmlns:wsa="http://www.w3.org/2005/08/addressing">
                            <hot:Credentials UserName="' . $username . '" Password="' . $password . '"></hot:Credentials>
                            <wsa:Action>http://TekTravel/HotelBookingApi/DestinationCityList</wsa:Action>
                            <wsa:To>https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc</wsa:To>
                        </soap:Header>
                        <soap:Body>
                            <hot:DestinationCityListRequest>
                                <hot:CountryCode>' . $country->country_code . '</hot:CountryCode>
                                <hot:ReturnNewCityCodes>true</hot:ReturnNewCityCodes>
                                <hot:Language>AR</hot:Language>
                            </hot:DestinationCityListRequest>
                            </soap:Body>
                    </soap:Envelope>
                ';
            $wsdl = "https://api.tbotechnology.in/hotelapi_v7/hotelservice.svc?WSDL";

            $client = new Client();

            $response = $client->request('POST', $wsdl, [
                'headers' => [
                    'Content-Type' => 'application/soap+xml; charset=utf-8',
                    'SOAPAction' => 'run',
                    'Accept' => 'text/xml',
                    'Cache-Control' => 'no-cache',
                    'Pragma' => 'no-cache',
                    'Content-length' => strlen($soap_request),
                    'User-Agent' => 'PHP-SOAP/7.0.10',
                    'Accept-Encoding' => 'gzip, deflate',
                ],
                'verify' => false,
                'auth' => [$username, $password],
                'body' => $soap_request,
            ]);

            $response = $response->getBody()->getContents();
            $doc = new DOMDocument('1.0', 'utf-8');
            $doc->loadXML($response);
            $XMLresults = $doc->getElementsByTagName("City");
            foreach ($XMLresults as $XMLresult) {
                $cityName = $XMLresult->getAttribute('CityName');
                $cityCode = $XMLresult->getAttribute('CityCode');
                // // Insert the city into the "tbo_cities" table
                $data = [
                    'country_id' => $country->id,
                    'city_name' => $cityName,
                    'city_code' => $cityCode,
                ];
                DB::table('tbo_cities')->insert($data);
            }
            DB::table('tbo_countries')
                ->where('id', $country->id)
                ->update([
                    'updated' => 1,
                ]);
        }
    }

    public function get_beds_countries()
    {
        // 'api_key' => '654f3adebe111b5f0dab7dac224619c2',
        // 'api_secret' => 'c4458411f6',

        // 'api_key' => 'c356fd8a35a076de09e02a6f4a70dae8',
        // 'api_secret' => '7ea00bc5c8',

        // 'api_key' => 'uxq7g6ru4b662qhnqs3xgv9e',
        // 'api_secret' => 'GZ4uwvpTRA',

        // "Api-key: uxq7g6ru4b662qhnqs3xgv9e",
        // "X-Signature: " . hash("sha256", 'uxq7g6ru4b662qhnqs3xgv9e' . 'GZ4uwvpTRA' . time()),

        $client = new Client();
        $headers = [
            'Api-key' => 'c356fd8a35a076de09e02a6f4a70dae8',
            // 'Api-key' => 'uxq7g6ru4b662qhnqs3xgv9e',
            // 'X-Signature' => hash("sha256", 'uxq7g6ru4b662qhnqs3xgv9e' . 'GZ4uwvpTRA' . time()),
            'X-Signature' => hash("sha256", 'c356fd8a35a076de09e02a6f4a70dae8' . '7ea00bc5c8' . time()),
            'Accept' => 'application/json',
            'Accept-Encoding' => 'gzip'
        ];
        $response = $client->request('GET', 'https://api.test.hotelbeds.com/hotel-content-api/1.0/locations/countries', [
            'headers' => $headers,
            'verify' => false,
        ]);
        $countries = json_decode($response->getBody())->countries;
        return $countries;
        foreach ($countries as $country) {
            $countryName = $country->description->content;
            $countryCode = $country->code;
            $data = [
                'country_name' => $countryName,
                'country_code' => $countryCode,
            ];
            DB::table('beds_countries')->insert($data);
        }
    }
    public function get_beds_cities()
    {
        // 'api_key' => '654f3adebe111b5f0dab7dac224619c2',
        // 'api_secret' => 'c4458411f6',

        // 'api_key' => 'c356fd8a35a076de09e02a6f4a70dae8',
        // 'api_secret' => '7ea00bc5c8',

        // 'api_key' => 'uxq7g6ru4b662qhnqs3xgv9e',
        // 'api_secret' => 'GZ4uwvpTRA',

        // "Api-key: uxq7g6ru4b662qhnqs3xgv9e",
        // "X-Signature: " . hash("sha256", 'uxq7g6ru4b662qhnqs3xgv9e' . 'GZ4uwvpTRA' . time()),

        $client = new Client();
        $headers = [
            // 'Api-key' => '654f3adebe111b5f0dab7dac224619c2',
            // 'X-Signature' => hash("sha256", '654f3adebe111b5f0dab7dac224619c2' . 'c4458411f6' . time()),

            'Api-key' => 'c356fd8a35a076de09e02a6f4a70dae8',
            'X-Signature' => hash("sha256", 'c356fd8a35a076de09e02a6f4a70dae8' . '7ea00bc5c8' . time()),

            // 'Api-key' => 'uxq7g6ru4b662qhnqs3xgv9e',
            // 'X-Signature' => hash("sha256", 'uxq7g6ru4b662qhnqs3xgv9e' . 'GZ4uwvpTRA' . time()),
            'Accept' => 'application/json',
            'Accept-Encoding' => 'gzip'
        ];
        $response = $client->request(
            'GET',
            'https://api.test.hotelbeds.com/hotel-content-api/1.0/locations/destinations?fields=all&language=ENG&from=1&to=500&useSecondaryLanguage=false',
            [
                'headers' => $headers,
                'verify' => false,
            ]
        );
        $destinations = json_decode($response->getBody())->destinations;
        return $countries;
        foreach ($countries as $country) {
            $countryName = $country->description->content;
            $countryCode = $country->code;
            $data = [
                'country_name' => $countryName,
                'country_code' => $countryCode,
            ];
            DB::table('beds_countries')->insert($data);
        }
    }

    public function get_dotw_countries()
    {
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => 'https://xmldev.dotwconnect.com/gatewayV4.dotw',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => '<customer>
            <username>SATA Travel</username>
            <password>' . md5('Sata@1234') . '</password>
            <id>1842675</id>
            <source>1</source>  
            <request command="getallcountries">  
                <return>  
                    <fields>  
                        <field>regionName</field>  
                        <field>regionCode</field>  
                    </fields>  
                </return>  
            </request></customer>',
                CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification
                CURLOPT_HTTPHEADER => array(
                    'Connection: close',
                    'Compression: Gzip',
                    'Content-Type: text/xml',
                    'Content-Type: application/x-www-form-urlencoded',
                    'Content-Encoding: gzip',
                ),
            )
        );
        $xml = curl_exec($curl);
        curl_close($curl);
        $xml = simplexml_load_string($xml);
        $json = json_encode($xml);
        return $json;
        $countries = json_decode($json, true)['countries']['country'];
        foreach ($countries as $country) {
            $name = $country['name'];
            $code = $country['code'];
            $region_code = $country['regionCode'];
            $data = [
                'country_name' => $name,
                'country_code' => $code,
                'region_code' => $region_code,
            ];
            DB::table('dotw_countries')->insert($data);
        }
    }

    public function get_dotw_cities()
    {
        ini_set('max_execution_time', '0');
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => 'https://xmldev.dotwconnect.com/gatewayV4.dotw',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => '<customer>
                <username>SATA Travel</username>
                <password>' . md5('Sata@1234') . '</password>
                <id>1842675</id>
                <source>1</source>  
                <request command="getallcities">  
                <return>  
                    <filters>  
                        <countryCode></countryCode>  
                        <countryName></countryName>  

                    </filters>  
                    <fields>  
                        <field>countryName</field>  
                        <field>countryCode</field>  
                        <field>language</field>  
                        <field>Arabic</field>  

                    </fields>  
                </return>  
            </request>  
                </customer>',
                CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification
                CURLOPT_HTTPHEADER => array(
                    'Connection: close',
                    'Compression: Gzip',
                    'Content-Type: text/xml',
                    'Content-Type: application/x-www-form-urlencoded',
                    'Content-Encoding: gzip',
                ),
            )
        );
        $xml = curl_exec($curl);
        curl_close($curl);
        $xml = simplexml_load_string($xml);
        $json = json_encode($xml);
        return $json;
        $cities = json_decode($json, true)['cities']['city'];
        foreach ($cities as $city) {
            $country_code = $city['countryCode'];
            $country = DB::table('dotw_countries')
                ->where('country_code', $country_code)->first();
            $name = $city['name'];
            $code = $city['code'];
            $data = [
                'city_name' => $name,
                'city_code' => $code,
                'country_id' => $country->id
            ];
            DB::table('dotw_cities')->insert($data);
        }
    }
    public function get_dotw_langs()
    {
        ini_set('max_execution_time', '0');
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => 'https://xmldev.dotwconnect.com/gatewayV4.dotw',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => '<customer>
                <username>SATA Travel</username>
                <password>' . md5('Sata@1234') . '</password>
                <id>1842675</id>
                <source>1</source>  

                <request command="getlanguagesids">
                <filed>Language</filed>
                <filed>Spanish</filed>
                </request>   
                </customer>',
                CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification
                CURLOPT_HTTPHEADER => array(
                    'Connection: close',
                    'Compression: Gzip',
                    'Content-Type: text/xml',
                    'Content-Type: application/x-www-form-urlencoded',
                    'Content-Encoding: gzip',
                ),
            )
        );
        $xml = curl_exec($curl);
        curl_close($curl);
        $xml = simplexml_load_string($xml);
        $json = json_encode($xml);
        return $json;
        $cities = json_decode($json, true)['cities']['city'];
        foreach ($cities as $city) {
            $country_code = $city['countryCode'];
            $country = DB::table('dotw_countries')
                ->where('country_code', $country_code)->first();
            $name = $city['name'];
            $code = $city['code'];
            $data = [
                'city_name' => $name,
                'city_code' => $code,
                'country_id' => $country->id
            ];
            DB::table('dotw_cities')->insert($data);
        }
    }

    // ================================================================================================
    public function merge_countries_code()
    {
        // $tbo_countries = DB::table('tbo_countries')->get()->keyBy('country_name');

        // foreach ($dotw_countries as $country_name => $dotw_country) {
        //     if ($tbo_countries->has($country_name)) {
        //         $tbo_country = $tbo_countries[$country_name];

        //         $merged_countries[] = [
        //             'country_name' => $country_name,
        //             'dotw_code' => $dotw_country->country_code,
        //             'tbo_code' => $tbo_country->country_code,
        //         ];
        //     }
        // }

        // return $merged_countries;
        // $dotw_countries = DB::table('dotw_countries')->get()->keyBy('country_name');
        // foreach ($dotw_countries as $dotw_country) {
        //     $data = [
        // 'dotw_code' => $dotw_country->country_code,
        // 'country_name' => $dotw_country->country_name
        // ];
        // DB::table('countries_code')->insert($data);
        // }
        $countries = DB::table('countries')->get();
        $countries_code = DB::table('countries_code')->get();

        foreach ($countries_code as $country_code) {
            $found = false;
            foreach ($countries as $country) {
                if (strtolower($country->code) == strtolower($country_code->tbo_code) && $country_code->tbo_code != 'Null') {
                    DB::table('countries_code')->where('tbo_code', $country->code)
                        ->update(['country_id' => $country->id]);
                    $found = true;
                    break;
                }
            }

            if (!$found) {
                if ($country_code->tbo_code) {
                    $new_country = [
                        'code' => $country_code->tbo_code,
                        'name_en' => $country_code->country_name,
                        'name_ar' => $country_code->country_name,
                    ];

                    // Insert into the 'countries' table and get the inserted ID
                    $country_id = DB::table('countries')->insertGetId($new_country);
                    // Insert into the 'countries_code' table with the retrieved country ID
                    DB::table('countries_code')->where('tbo_code', $country->code)->update([
                        'country_id' => $country_id,
                    ]);
                }
                // $new_country = DB::table('countries')->insertGetId([
                //     'code' => $country_code->tbo_code,
                //     'name_en' => $country_code->country_name,
                // ]);

                // DB::table('countries_code')->insert([
                //     'country_id' => $new_country->id,
                // ]);
            }
        }
    }

    //=================================================================================================
    public function merge_cities()
    {
        $cities = DB::table('cities')->get();
        foreach ($cities as $city) {
            $data = [
                'wow_code' => $city->cityCode,
                'city_name' => $city->name_en,
                'city_id' => $city->id,
            ];
            $found = DB::table('cities_code')->where('city_name', $city->name_en)->first();
            if (!$found) {
                DB::table('cities_code')->insert($data);
            }
        }
    }

    public function merge_tbo_with_cities()
    {
        $tbo_cities = DB::table('tbo_cities')->get();
        $cities = DB::table('cities')->get();

        foreach ($tbo_cities as $tbo_city) {
            $matched = false;

            foreach ($cities as $city) {
                if (strtolower($tbo_city->city_name) == strtolower($city->name_en)) {
                    DB::table('cities_code')->updateOrInsert(
                        ['city_name' => $tbo_city->city_name],
                        [
                            'tbo_code' => $tbo_city->city_code,
                            'city_id' => $city->id
                        ]
                    );
                    $matched = true;
                    break; // No need to continue searching for this TBO city
                }
            }

            if (!$matched) {
                // Check if the city_name already exists in cities_code table
                $existingCityCode = DB::table('cities_code')
                    ->where('city_name', $tbo_city->city_name)
                    ->first();

                if (!$existingCityCode) {
                    $new_city = [
                        'name_en' => $tbo_city->city_name,
                    ];

                    $city_id = DB::table('cities')->insertGetId($new_city);

                    DB::table('cities_code')->insert([
                        'city_name' => $tbo_city->city_name,
                        'tbo_code' => $tbo_city->city_code,
                        'city_id' => $city_id
                    ]);
                }
            }
        }

        // return $tbo_cities;
    }
    public function merge_dotw_with_cities()
    {
        $dotw_cities = DB::table('dotw_cities')->get();
        $cities = DB::table('cities')->get();

        foreach ($dotw_cities as $dotw_city) {
            $matched = false;

            foreach ($cities as $city) {
                if (strtolower($dotw_city->city_name) == strtolower($city->name_en)) {
                    DB::table('cities_code')->updateOrInsert(
                        ['city_name' => $dotw_city->city_name],
                        [
                            'dotw_code' => $dotw_city->city_code,
                            'city_id' => $city->id
                        ]
                    );
                    $matched = true;
                    break; // No need to continue searching for this dotw city
                }
            }

            if (!$matched) {
                // Check if the city_name already exists in cities_code table
                $existingCityCode = DB::table('cities_code')
                    ->where('city_name', $dotw_city->city_name)
                    ->first();

                if (!$existingCityCode) {
                    $new_city = [
                        'name_en' => $dotw_city->city_name,
                    ];

                    $city_id = DB::table('cities')->insertGetId($new_city);

                    DB::table('cities_code')->insert([
                        'city_name' => $dotw_city->city_name,
                        'dotw_code' => $dotw_city->city_code,
                        'city_id' => $city_id
                    ]);
                }
            }
        }

        // return $dotw_cities;
    }

    public function get_alike_city_name()
    {

        // Perform the database query to retrieve all city names
        $cityNames = DB::table('cities_code')
            ->select('city_name')
            ->get();

        // Create an associative array to store grouped cities
        $groupedCities = [];

        foreach ($cityNames as $city) {
            $matchedGroup = false;

            // Check if the city matches with any existing group
            foreach ($groupedCities as $groupName => $groupCities) {
                foreach ($groupCities as $groupCity) {
                    similar_text($city->city_name, $groupCity, $similarity);

                    if ($similarity >= 70) { // You can adjust this similarity threshold
                        $groupedCities[$groupName][] = $city->city_name;
                        $matchedGroup = true;
                        break 2; // Break out of the outer loop
                    }
                }
            }

            // If no existing group matches, create a new group
            if (!$matchedGroup) {
                $groupedCities[] = [$city->city_name];
            }
        }

        return $groupedCities;
    }

    public function hotel_mapping()
    {
        ini_set('max_execution_time', '0');
        // return $this->get_dotw_hotels();
        // return $this->merge_dotw_hotels_with_hotel_list();
        // return $this->get_dotw_langs();
        // $this->merge_cities();
        // $this->merge_tbo_with_cities();
        // $this->merge_dotw_with_cities();
        // return $this->get_alike_city_name();
        // return $this->fill_tbo_cities();
        // return $this->fill_tbo_hotels();
        // return $this->merge_cities_wih_same_tbo_code();
        // return $this->match_airports_city_id();
        // return $this->fill_airports();
        // return $this->fill_airports_city();
        // return $this->fill_airports_country();
        return $this->fill_nationalities();
        return "merged";
    }
    /////////////////////////==========================hotels 

    public function merge_dotw_and_tbo_city_codes()
    {
        $tbo_cities = DB::table('tbo_city_list')
            ->where('dotw_added', 0)
            ->get();

        return $tbo_cities;

        foreach ($tbo_cities as $tbo_city) {
            $dotw_cities = DB::table('dotw_cities')
                ->where('code_updated', 0)
                ->where('country_code', strtolower($tbo_city->country_code))
                ->get();
            // return $dotw_cities;

            foreach ($dotw_cities as $dotw_city) {
                if (strtolower($tbo_city->name_en) == strtolower($dotw_city->city_name)) {
                    echo $tbo_city->country_code . "--- Match found: {$tbo_city->name_en} == {$dotw_city->city_name} <br>";
                    break; // Once a match is found, no need to continue the inner loop
                } else {
                    echo $tbo_city->country_code . "--- Not:" . strtolower($tbo_city->name_en) == strtolower($dotw_city->city_name) . "<br>";
                }
            }
        }


        return "jdjfdjfjd";

        foreach ($tboCities as $tboCity) {
            $tboCityNameParts = explode(' ', strtolower($tboCity->name_en));
            $tboCityNameParts = array_filter($tboCityNameParts); // Remove empty parts
            return $tboCityNameParts;
            if (count($tboCityNameParts) >= 2) {
                foreach ($dotwCities as $dotwCityKey => $dotwCity) {

                    if (strpos($dotwCityKey, $tboCity->country_code) !== false) {
                        $dotwCityNameParts = explode('_', $dotwCityKey);
                        $dotwCityNameParts = array_filter($dotwCityNameParts); // Remove empty parts

                        if (count($dotwCityNameParts) >= 2) {
                            // Check if any part of the TBO city name matches with a part of the DOTW city key
                            foreach ($tboCityNameParts as $tboPart) {
                                if (in_array($tboPart, $dotwCityNameParts)) {
                                    // DB::table('tbo_city_list')
                                    //     ->where('id', $tboCity->id)
                                    //     ->update([
                                    //         'dotw_code' => $dotwCity->city_code,
                                    //         'dotw_added' => 1
                                    //     ]);

                                    // DB::table('dotw_cities')
                                    //     ->where('id', $dotwCity->id)
                                    //     ->update([
                                    //         'code_updated' => 1
                                    //     ]);

                                    echo 'Country: ' . $tboCity->country_code . ' ------- city ' . strtolower($tboCity->name_en) . ' likes ----' . $dotwCity->country_code . ' ---  ' . strtolower($dotwCity->city_name) . '  YESSSSS <br>';

                                    $mergedCount++;
                                    // break; // No need to check further for this TBO city
                                }
                            }
                        }
                        return $tboPart;
                    }
                }
            }
        }

        return $mergedCount;
    }

    public function merge_cities_city_list()
    {
        $new_cities = DB::table('cities')->where('updated', 0)->limit(1000)->get();
        $merged_cities = [];
        foreach ($new_cities as $new_city) {
            $old_cities = DB::table('city_list')->where('updated', 0)->get();
            foreach ($old_cities as $old_city) {
                if ($old_city->city_name_en == $new_city->name_en) {
                    $merged_cities[] = $old_city;
                }
            }
        }
        return $merged_cities;
    }
    public function get_dotw_hotels()
    {
        $cities = DB::table('dotw_cities')->where('updated', 0)->limit(1)->get();
        foreach ($cities as $city) {
            $xmlRequest = '
                <customer>
                    <username>SATA Travel</username>
                    <password>' . md5('Sata@1234') . '</password>
                    <id>1842675</id>
                    <source>1</source>
                    <product>hotel</product>
                    <language>en</language>
                    <request command="searchhotels">
                        <bookingDetails>
                            <fromDate>2023-11-10</fromDate>
                            <toDate>2023-11-12</toDate>
                            <currency>520</currency>
                            <rooms no="1">
                                <room runno="0">
                                    <adultsCode>2</adultsCode>
                                    <children no="0"></children>
                                    <rateBasis>-1</rateBasis>
                                    <passengerNationality>81</passengerNationality>
                                    <passengerCountryOfResidence>81</passengerCountryOfResidence>
                                </room>
                            </rooms>
                        </bookingDetails>
                        <return>
                            <filters xmlns:a="http://us.dotwconnect.com/xsd/atomicCondition" xmlns:c="http://us.dotwconnect.com/xsd/complexCondition">
                                <city>' . $city->city_code . '</city>
                                <noPrice>true</noPrice>
                            </filters>
                            <fields>
                                <field>preferred</field>
                                <field>builtYear</field>
                                <field>renovationYear</field>
                                <field>floors</field>
                                <field>noOfRooms</field>
                                <field>preferred</field>
                                <field>luxury</field>
                                <field>fullAddress</field>
                                <field>description1</field>
                                <field>description2</field>
                                <field>hotelName</field>
                                <field>address</field>
                                <field>zipCode</field>
                                <field>location</field>
                                <field>locationId</field>
                                <field>location1</field>
                                <field>location2</field>
                                <field>location3</field>
                                <field>cityName</field>
                                <field>cityCode</field>
                                <field>stateName</field>
                                <field>stateCode</field>
                                <field>countryName</field>
                                <field>countryCode</field>
                                <field>regionName</field>
                                <field>regionCode</field>
                                <field>attraction</field>
                                <field>amenitie</field>
                                <field>leisure</field>
                                <field>business</field>
                                <field>transportation</field>
                                <field>hotelPhone</field>
                                <field>hotelCheckIn</field>
                                <field>hotelCheckOut</field>
                                <field>minAge</field>
                                <field>rating</field>
                                <field>images</field>
                                <field>fireSafety</field>
                                <field>hotelPreference</field>
                                <field>direct</field>
                                <field>geoPoint</field>
                                <field>leftToSell</field>
                                <field>chain</field>
                                <field>lastUpdated</field>
                                <field>priority</field>
                                <roomField>name</roomField>
                                <roomField>roomInfo</roomField>
                                <roomField>roomAmenities</roomField>
                                <roomField>twin</roomField>
                         </fields>
                        </return>
                    </request>
                </customer>
            ';

            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                    CURLOPT_URL => 'https://xmldev.dotwconnect.com/gatewayV4.dotw',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => $xmlRequest,
                    CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification
                    CURLOPT_HTTPHEADER => array(
                        'Connection: close',
                        'Compression: Gzip',
                        'Content-Type: text/xml',
                        'Content-Type: application/x-www-form-urlencoded',
                        'Content-Encoding: gzip',
                    ),
                )
            );

            $curlResponse = curl_exec($curl);
            curl_close($curl);

            $xmlData = simplexml_load_string($curlResponse);
            $jsonData = json_encode($xmlData);
            $data = json_decode($jsonData, true);
            $hotels = [];
            $hotels_count = isset($data['hotels']['@attributes']['count']) ? $data['hotels']['@attributes']['count'] : 0;
            if ($hotels_count == 0) {
                DB::table('dotw_cities')
                    ->where('id', $city->id)
                    ->update([
                        'updated' => 1,
                    ]);
                DB::table('dotw_cities')
                    ->where('id', $city->id)
                    ->update([
                        'found_hotels' => 0,
                    ]);
                break;
            }
            if ($hotels_count > 1) {
                $hotels = $data['hotels']['hotel'];
            } else {
                $hotels[] = $data['hotels']['hotel'];
            }
            foreach ($hotels as $hotel) {
                $data = [
                    'city_code' => $city->city_code,
                    'hotel_code' => isset($hotel['@attributes']['hotelid']) ? $hotel['@attributes']['hotelid'] : $hotel['hotelid'],
                    'cityName' => $city->city_name,
                    'hotelName' => isset($hotel['hotelName']) && !empty($hotel['hotelName']) ? $hotel['hotelName'] : '',
                    'stateName' => isset($hotel['stateName']) && !empty($hotel['stateName']) ? json_encode($hotel['stateName']) : '',
                    'preferred' => isset($hotel['preferred'])  && !empty($hotel['preferred']) ? $hotel['preferred'] : '',
                    'builtYear' => isset($hotel['builtYear']) && !empty($hotel['builtYear']) ? json_encode($hotel['builtYear']) : '',
                    'renovationYear' => isset($hotel['renovationYear']) && !empty($hotel['renovationYear']) ? $hotel['renovationYear'] : '',
                    'floors' => isset($hotel['floors']) && !empty($hotel['floors']) ? $hotel['floors'] : '',
                    'noOfRooms' => isset($hotel['noOfRooms']) && !empty($hotel['noOfRooms']) ? $hotel['noOfRooms'] : '',
                    'luxury' => isset($hotel['luxury']) && !empty($hotel['luxury']) && $hotel['luxury'] != 'false' ? json_encode($hotel['luxury']) : '',
                    'location1' => isset($hotel['location1']) && !empty($hotel['location1']) ? json_encode($hotel['location1']) : '',
                    'location2' => isset($hotel['location2']) && !empty($hotel['location2']) ? json_encode($hotel['location2']) : '',
                    'location3' => isset($hotel['location3']) && !empty($hotel['location3']) ? json_encode($hotel['location3']) : '',
                    'address' => isset($hotel['address']) && !empty($hotel['address']) ? $hotel['address'] : '',
                    'location' => isset($hotel['location']) && !empty($hotel['location']) ? $hotel['location'] : "",
                    'locationId' => isset($hotel['locationId']) && !empty($hotel['locationId']) ? $hotel['locationId'] : '',
                    'zipCode' => isset($hotel['zipCode']) && !empty($hotel['zipCode']) ? $hotel['zipCode'] : '',
                    'cityCode' => isset($hotel['cityCode']) && !empty($hotel['cityCode']) ? $hotel['cityCode'] : '',
                    'stateCode' => isset($hotel['stateCode']) && !empty($hotel['stateCode']) ? $hotel['stateCode'] : '',
                    'countryName' => isset($hotel['countryName']) && !empty($hotel['countryName']) ? $hotel['countryName'] : '',
                    'countryCode' => isset($hotel['countryCode']) && !empty($hotel['countryCode']) ? $hotel['countryCode'] : '',
                    'regionName' => isset($hotel['regionName']) && !empty($hotel['regionName']) ? $hotel['regionName'] : '',
                    'regionCode' => isset($hotel['regionCode']) && !empty($hotel['regionCode']) ? $hotel['regionCode'] : '',
                    'attraction' => isset($hotel['attraction']) && !empty($hotel['attraction']) ? json_encode($hotel['attraction']) : '',
                    'hotelPhone' => isset($hotel['hotelPhone']) && !empty($hotel['hotelPhone']) ? $hotel['hotelPhone'] : '',
                    'hotelCheckOut' => isset($hotel['hotelCheckOut']) && !empty($hotel['hotelCheckOut']) ? $hotel['hotelCheckOut'] : '',
                    'hotelCheckIn' => isset($hotel['hotelCheckIn']) && !empty($hotel['hotelCheckIn']) ? $hotel['hotelCheckIn'] : '',
                    'rating' => isset($hotel['rating']) && !empty($hotel['rating']) ? $hotel['rating'] : '',
                    'minAge' => isset($hotel['minAge']) && !empty($hotel['minAge']) ? $hotel['minAge'] : '',
                    'fireSafety' => isset($hotel['fireSafety']) && !empty($hotel['fireSafety']) ? $hotel['fireSafety'] : '',
                    'chain' => isset($hotel['chain']) && !empty($hotel['chain']) ? $hotel['chain'] : '',
                    'direct' => isset($hotel['direct']) && !empty($hotel['direct']) ? $hotel['direct'] : '',
                    'lastUpdated' => isset($hotel['lastUpdated']) && !empty($hotel['lastUpdated']) ? $hotel['lastUpdated'] : '',
                    'priority' => isset($hotel['priority']) && !empty($hotel['priority']) ? $hotel['priority'] : '',
                    'fullAddress' => isset($hotel['fullAddress']) && !empty($hotel['fullAddress']) ? json_encode($hotel['fullAddress']) : '',
                    'description1' => isset($hotel['description1']) && !empty($hotel['description1']) ? json_encode($hotel['description1']) : '',
                    'description2' => isset($hotel['description2']) && !empty($hotel['description2']) ? json_encode($hotel['description2']) : '',
                    'amenitie' => isset($hotel['amenitie']) && !empty($hotel['amenitie']) ? json_encode($hotel['amenitie']) : '',
                    'leisure' => isset($hotel['leisure']) && !empty($hotel['leisure']) ? json_encode($hotel['leisure']) : '',
                    'business' => isset($hotel['business']) && !empty($hotel['business']) ? json_encode($hotel['business']) : '',
                    'transportation' => isset($hotel['transportation']) && !empty($hotel['transportation']) ? json_encode($hotel['transportation']) : '',
                    'images' => isset($hotel['images']) && !empty($hotel['images']) ? json_encode($hotel['images']) : '',
                    'hotelPreference' => isset($hotel['hotelPreference']) && !empty($hotel['hotelPreference']) ? json_encode($hotel['hotelPreference']) : '',
                    'geoPoint' => isset($hotel['geoPoint']) && !empty($hotel['geoPoint']) ? json_encode($hotel['geoPoint']) : '',
                ];
                return $data;
                DB::table('dotw_hotel_codes')->insert($data);

                DB::table('dotw_cities')
                    ->where('id', $city->id)
                    ->update([
                        'found_hotels' => $hotels_count,
                    ]);
            }
            DB::table('dotw_cities')
                ->where('id', $city->id)
                ->update([
                    'updated' => 1,
                ]);
        }
    }

    public function get_dotw_get_rooms()
    {
        $cities = DB::table('dotw_cities')->limit(1000)->get();
        foreach ($cities as $city) {
            $xmlRequest = '
                <customer>
                    <username>SATA Travel</username>
                    <password>' . md5('Sata@1234') . '</password>
                    <id>1842675</id>
                    <source>1</source>
                    <product>hotel</product>
                    <language>750</language>
                    <request command="getrooms">
                        <bookingDetails>
                            <fromDate>2023-11-10</fromDate>
                            <toDate>2023-11-12</toDate>
                            <currency>520</currency>
                            <rooms no="1">
                                <room runno="0">
                                    <adultsCode>2</adultsCode>
                                    <children no="0"></children>
                                    <rateBasis>-1</rateBasis>
                                    <passengerNationality>81</passengerNationality>
                                    <passengerCountryOfResidence>81</passengerCountryOfResidence>
                                </room>
                            
                            </rooms>
                            <productId>30674</productId>
                            
                        </bookingDetails>
                    </request>
                </customer>
            ';

            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                    CURLOPT_URL => 'https://xmldev.dotwconnect.com/gatewayV4.dotw',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => $xmlRequest,
                    CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification
                    CURLOPT_HTTPHEADER => array(
                        'Connection: close',
                        'Compression: Gzip',
                        'Content-Type: text/xml',
                        'Content-Type: application/x-www-form-urlencoded',
                        'Content-Encoding: gzip',
                    ),
                )
            );

            $curlResponse = curl_exec($curl);
            curl_close($curl);

            $xmlData = simplexml_load_string($curlResponse);
            $jsonData = json_encode($xmlData);
            $data = json_decode($jsonData, true);
            return $data;
            if (isset($data['hotels']['hotel']) && $data['hotels']['hotel'] != "null") {
                DB::table('dotw_cities')
                    ->where('id', $city->id)
                    ->update([
                        'found_hotels' => 1,
                    ]);
                foreach ($data['hotels']['hotel'] as $hotel) {
                    if (isset($hotel['hotelid'])) {
                        $hotelId = $hotel['hotelid'];
                        DB::table('dotw_hotel_codes')->insert([
                            'city_code' => $city->city_code,
                            'hotel_code' => $hotelId,
                            'city_name' => $city->city_name,
                        ]);
                    }

                    if (isset($hotel['@attributes']['hotelid'])) {
                        $hotelId = $hotel['@attributes']['hotelid'];
                        DB::table('dotw_hotel_codes')->insert([
                            'city_code' => $city->city_code,
                            'hotel_code' => $hotelId,
                            'city_name' => $city->city_name,
                        ]);
                    }
                }
            }

            DB::table('dotw_cities')
                ->where('id', $city->id)
                ->update([
                    'updated' => 1,
                ]);
        }
    }

    public function merge_dotw_hotels_with_hotel_list()
    {
        $hotel_list = DB::table('hotel_list')->get();
        $dotw_hotels = DB::table('dotw_hotel_codes')->get();
        $mapped = [];
        foreach ($hotel_list as $hotel) {
            foreach ($dotw_hotels as $dotw_hotel) {
                if (strtolower($hotel->city_name_en) == strtolower($dotw_hotel->city_name)) {
                    $mapped[] = [
                        'dotw_code' => $dotw_hotel->hotel_code,
                        'dotw_name' => $dotw_hotel->city_name,
                        'hotel_name' => $hotel->city_name_en
                    ];
                }
            }
        }
        return $mapped;
    }

    public function fill_countries()
    {
        $wowCountries = DB::table('wow_countries')->get();
        foreach ($wowCountries as $wowCountry) {
            $country = new Country();
            $country->iso3 = $wowCountry->iso3;
            $country->numeric_code = $wowCountry->numeric_code;
            $country->code = $wowCountry->iso2;
            $country->phonecode = $wowCountry->phonecode;
            $country->capital = $wowCountry->capital;
            $country->currency = $wowCountry->currency;
            $country->currency_name = $wowCountry->currency_name;
            $country->currency_symbol = $wowCountry->currency_symbol;
            $country->tld = $wowCountry->tld;
            $country->native = $wowCountry->native;
            $country->region = $wowCountry->region;
            $country->subregion = $wowCountry->subregion;
            $country->timezones = $wowCountry->timezones;
            $country->lat = $wowCountry->latitude; // Corrected field name
            $country->lng = $wowCountry->longitude; // Corrected field name
            $country->emoji = $wowCountry->emoji;
            $country->emojiU = $wowCountry->emojiU;
            $country->flag = $wowCountry->flag;
            $country->wikiDataId = $wowCountry->wikiDataId;
            $country->save();

            // Handle translations
            $translationsJson = $wowCountry->translations;
            if (!empty($translationsJson)) {
                $translationsArray = json_decode($translationsJson, true);
                foreach ($translationsArray as $locale => $translation) {
                    $country->translateOrNew($locale)->name = $translation;
                }
                $country->save();
            }
            $country->translateOrNew('ar')->name = $wowCountry->name_ar;
            $country->translateOrNew('en')->name = $wowCountry->name_en;
            $country->save();
        }

        return "Countries filled successfully.";
    }

    public function fill_cities()
    {
        $city = City::where('id', 1)->first();
        $wowCities = DB::table('wow_cities')->where('updated', 0)->get();

        foreach ($wowCities as $wowCity) {
            $city = new City();
            $city->country_id = $wowCity->country_id;
            $city->country_code = $wowCity->country_code;
            $city->state_id = $wowCity->state_id;
            $city->state_code = $wowCity->state_code;
            $city->lat = $wowCity->lat;
            $city->lng = $wowCity->lng;
            $city->flag = $wowCity->flag;
            $city->wikidataid = $wowCity->wikiDataId;
            $city->translateOrNew('ar')->name = $wowCity->name_ar;
            $city->translateOrNew('en')->name = $wowCity->name_en;

            // Save the city record
            $city->save();

            // Update the 'updated' flag in the 'wow_cities' table
            DB::table('wow_cities')->where('id', $wowCity->id)->update(['updated' => 1]);
        }

        return "Cities filled successfully.";
    }

    public function fill_tbo_cities()
    {

        $wowCities = DB::table('city_list')->where('updated', 0)->get();

        foreach ($wowCities as $wowCity) {
            $existingCity = City::where('country_code', strtolower($wowCity->country_code))
                ->whereHas('translations', function ($query) use ($wowCity) {
                    $query->where('name', strtolower($wowCity->city_name_en));
                })
                ->first();

            if ($existingCity) {
                $supplier_city = new SupplierCity();
                if ($wowCity->city_tbo_code != null && $wowCity->city_tbo_code != '') {
                    $supplier_city->city_id = $existingCity->id;
                    $supplier_city->supplier_id = 15;
                    $supplier_city->code = $wowCity->city_tbo_code;
                    $supplier_city->save();
                }
            } else {
                $newCity = new City();
                $country = Country::where('code', strtolower($wowCity->country_code))->first();
                $newCity->country_id = $country ? $country->id : '';
                $newCity->country_code = $wowCity->country_code;
                $newCity->translateOrNew('ar')->name = $wowCity->city_name_ar;
                $newCity->translateOrNew('en')->name = $wowCity->city_name_en;
                $newCity->save();

                if ($wowCity->city_tbo_code != null && $wowCity->city_tbo_code != '') {
                    $supplier_city = new SupplierCity();
                    $supplier_city->city_id = $newCity->id;
                    $supplier_city->supplier_id = 15;
                    $supplier_city->code = $wowCity->city_tbo_code;
                    $supplier_city->save();
                }
            }

            // Update the 'updated' flag in the 'city_list' table
            DB::table('city_list')->where('city_id', $wowCity->city_id)->update(['updated' => 1]);
        }

        return "Cities filled successfully.";
    }

    public function merge_cities_wih_same_tbo_code()
    {
        // $id = 177849;
        // return $this->delete_city($id);

        $nonDistinctCodesAndCityIds = SupplierCity::select('code', 'supplier_id')
            ->groupBy('code', 'supplier_id')
            ->havingRaw('COUNT(*) > 1')
            ->get();

        foreach ($nonDistinctCodesAndCityIds as $nonDistinct) {
            $code = $nonDistinct->code;
            $supplierId = $nonDistinct->supplier_id;

            $records[] = SupplierCity::where('code', $code)
                ->where('supplier_id', $supplierId)
                ->orderBy('id', 'desc') // Order by id in descending order
                ->get();
            // return $records;
        }
        return ['count' => count($records), 'records' => $records];
    }

    public function delete_city($id)
    {
        $city = City::findOrFail($id);

        $city->translations()->delete();

        $city->delete();
    }

    public function fill_tbo_hotels()
    {
        $wowHotels = DB::table('wow_hotels')->where('updated', 0)->limit(20000)->get();

        foreach ($wowHotels as $wowHotel) {
            // return $wowHotel;
            $hotel = new Hotel();
            $hotel->city_id = SupplierCity::getCityId(15, $wowHotel->hotel_city_tbo_code);
            $hotel->country_code = $wowHotel->hotel_country_code;
            $hotel->lat = $wowHotel->hotel_lat;
            $hotel->lng = $wowHotel->hotel_lng;
            $hotel->phone = $wowHotel->hotel_phone;
            $hotel->fax = $wowHotel->hotel_fax;
            $hotel->website = $wowHotel->hotel_website;
            $hotel->email = $wowHotel->hotel_email;
            $hotel->main_image = $wowHotel->hotel_main_image;
            $hotel->gallery = array_filter(
                array_merge(
                    array_filter(explode(',', $wowHotel->hotel_gallery)),
                    array_diff(
                        array_filter(explode(',', $wowHotel->hotel_online_tbo_gallery)),
                        array_filter(explode(',', $hotel->gallery))
                    )
                ),
                function ($value) {
                    return $value !== '';
                }
            );
            $hotel->pincode = $wowHotel->hotel_pincode;
            $hotel->rating = $wowHotel->hotel_rating;
            $hotel->tripadvisor_rating = $wowHotel->hotel_tripadvisor_rating;
            $hotel->tripadvisor_review_url = $wowHotel->hotel_tripadvisor_review_url;
            $hotel->weight = $wowHotel->hotel_weight;
            $hotel->facilities = $this->fill_hotel_facilities($wowHotel->hotel_facilities_en, $wowHotel->hotel_facilities_ar);

            // Set the translations for the Hotel
            $hotel->translateOrNew('ar')->name = $wowHotel->hotel_name_ar;
            $hotel->translateOrNew('en')->name = $wowHotel->hotel_name_en;
            $hotel->translateOrNew('ar')->attractions = $wowHotel->hotel_attractions_ar;
            $hotel->translateOrNew('en')->attractions = $wowHotel->hotel_attractions_en;
            // $hotel->translateOrNew('ar')->facilities = $wowHotel->hotel_facilities_ar;
            // $hotel->translateOrNew('en')->facilities = $wowHotel->hotel_facilities_en;
            $hotel->translateOrNew('ar')->room_facilities = $wowHotel->hotel_room_facilities_ar;
            $hotel->translateOrNew('en')->room_facilities = $wowHotel->hotel_room_facilities_en;
            $hotel->translateOrNew('ar')->services = $wowHotel->hotel_services_ar;
            $hotel->translateOrNew('en')->services = $wowHotel->hotel_services_en;
            $hotel->translateOrNew('ar')->policy = $wowHotel->hotel_policy_ar;
            $hotel->translateOrNew('en')->policy = $wowHotel->hotel_policy_en;
            $hotel->translateOrNew('ar')->description = $wowHotel->hotel_desc_ar;
            $hotel->translateOrNew('en')->description = $wowHotel->hotel_desc_en;
            $hotel->translateOrNew('ar')->address = $wowHotel->hotel_address_ar;
            $hotel->translateOrNew('en')->address = $wowHotel->hotel_address_en;
            // Save the Hotel record
            // return $hotel;
            $hotel->save();
            SupplierHotel::create([
                'supplier_id' => 15,
                'hotel_id' => $hotel->id,
                'code' => $wowHotel->hotel_tbo_code,
            ]);
            DB::table('wow_hotels')->where('hotel_id', $wowHotel->hotel_id)->update(['updated' => 1]);
        }
    }

    public function fill_hotel_facilities($facilities_en, $facilities_ar)
    {
        $en = explode(',', $facilities_en);
        $ar = explode('،', $facilities_ar);

        $pairs = [];

        // Make sure both arrays have the same number of items
        if (count($en) == count($ar)) {
            for ($i = 0; $i < count($en); $i++) {
                $enItem = trim($en[$i]);
                $arItem = trim($ar[$i]);

                // Check if both items are not empty
                if (!empty($enItem) && !empty($arItem)) {
                    $pairs[$enItem] = $arItem;
                }
            }
        }
        $ids = [];
        foreach ($pairs as $k => $v) {
            $existingFacility = HotelFacilityTranslation::where('name', $k)->orWhere('name', $v)->first();
            if ($existingFacility) {
                $facility = $existingFacility->Facility;
                $facility->translateOrNew('en')->name = $k;
                $facility->translateOrNew('ar')->name = $v;
                $facility->save();
            } else {
                $facility = new HotelFacility();
                $facility->translateOrNew('en')->name = $k;
                $facility->translateOrNew('ar')->name = $v;
                $facility->save();
            }
            $ids[] = $facility->id;
        }
        return $ids;
    }

    public function match_airports_city_id()
    {
        $wowAirports = DB::table('wow_airports')->where('city_updated', 0)->limit(1000)->get();
        foreach ($wowAirports as $wowAirport) {
            $city_supplier = CityTranslation::where('name', $wowAirport->city)->first();

            if ($city_supplier) {
                $city_id = $city_supplier->city_id;
                // Update the 'city' column in the 'wow_airports' table
                DB::table('wow_airports')
                    ->where('id', $wowAirport->id)
                    ->update(['city' => $city_id]);
            }
            // Update the 'city_updated' flag in the 'wow_airports' table
            DB::table('wow_airports')
                ->where('id', $wowAirport->id)
                ->update(['city_updated' => 1]);
        }
    }

    public function fill_airports()
    {
        $wowAirports = DB::table('wow_airports_clone_city_step_1')->where('updated', 0)->get();
        foreach ($wowAirports as $wowAirport) {
            $airport = new Airport();
            $airport->translateOrNew('ar')->name = $wowAirport->name_ar;
            $airport->translateOrNew('en')->name = $wowAirport->name_en;
            // $airport->country_id = $wowAirport->country;
            $airport->city_id = $wowAirport->city;
            $airport->code = $wowAirport->code;
            $airport->IcanCode = $wowAirport->IcanCode;
            $airport->lat = $wowAirport->lat;
            $airport->lng = $wowAirport->lng;
            $airport->timeplus = $wowAirport->timeplus;
            $airport->timeCode = $wowAirport->timeCode;
            $airport->timezone = $wowAirport->timezone;
            $airport->type = $wowAirport->type;
            $airport->ourairport = $wowAirport->ourairport;

            // Save the airport record
            $airport->save();

            // Update the 'updated' flag in the 'wow_airports' table
            DB::table('wow_airports_clone_city_step_1')->where('id', $wowAirport->id)->update(['updated' => 1]);
        }

        return "Airports filled successfully.";
    }

    public function fill_airports_city()
    {
        $wow_airports = DB::table('wow_airports_clone')
            ->where('updated', 0)
            // ->limit(10)
            ->get();

        foreach ($wow_airports as $wow_airport) {
            $city_name = $wow_airport->city;
            $country_id = $wow_airport->country;

            // $city = DB::table('cities')
            //     ->orWhereRaw('LOWER(cityName) = ?', [strtolower($city_name)])
            //     ->first();
            $city = CityTranslation::with('city')
                ->whereRaw('LOWER(name) LIKE ?', ['%' . strtolower($city_name) . '%'])
                ->first();

            if ($city /* &&$city->city_country && $city->city_country->id == $country_id */) {
                // Update 'wow_airports_clone' record with city information
                DB::table('wow_airports_clone')
                    ->where('id', $wow_airport->id)
                    ->update([
                        'city' => $city->city->id,
                        'updated' => 1
                    ]);
            } else {
                // Handle the case where no matching city is found
                // You might want to log this as an error or take other action
                // For now, let's update 'city_updated' to 1 to prevent reprocessing
                DB::table('wow_airports_clone')
                    ->where('id', $wow_airport->id)
                    ->update([
                        'city_updated' => 1
                    ]);
            }
        }

        return $wow_airports;
    }

    public function fill_airports_country()
    {
        $wow_airports = DB::table('wow_airports_clone')
            ->where('updated', 0)
            // ->limit(1)
            ->get();

        foreach ($wow_airports as $wow_airport) {
            $airport = DB::table('airports_correct_countries')
                ->where('name_en', $wow_airport->name_en)
                ->first();

            if ($airport) {
                DB::table('wow_airports_clone')
                    ->where('id', $wow_airport->id)
                    ->update([
                        'country' => $airport->country,
                        'updated' => 1
                    ]);
            } else {

                DB::table('wow_airports_clone')
                    ->where('id', $wow_airport->id)
                    ->update([
                        'updated' => 1
                    ]);
            }
        }

        return $wow_airports;
    }

    public function fill_nationalities()
    {
        $wow_nations = DB::table('wow_nationalities')->get();
        foreach ($wow_nations as $wow_nation) {
            $nation = new Nationality();
            $nation->translateOrNew('ar')->name = $wow_nation->nationality_ar;
            $nation->translateOrNew('en')->name = $wow_nation->nationality_en;
            $nation->country_id = $wow_nation->country_code;
            $nation->save();
        }
    }
}
