<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Crypt;

class Supplier extends Model
{
    use HasFactory;

    protected $table = "suppliers";
    protected $fillable = [
        'name',
        'key',
        'module_id',
        'settings',
        'status',
        'desc'
    ];
    public $timestamps = true;
    protected $casts = [
        'settings' => 'array'
    ];

    public function getUserSupplierSettingsAttribute($user_id)
    {
        $supplier = UserSupplier::where('user_id', $user_id)->where('supplier_id', $this->id)->first();
        $encryptedSettings = $supplier->supplier_settings ?? [];
        $decryptedSettings = [];
        if (count($encryptedSettings) > 0) {
            foreach ($encryptedSettings as $key => $encryptedValue) {
                $decryptedValue = Crypt::decryptString($encryptedValue);
                $decryptedSettings[$key] = $decryptedValue;
            }
        }
        return $decryptedSettings;
    }

    public function getSupplierMarkupSettingsAttribute($agent_id)
    {
        $supplier = Markup::where('agent_id', $agent_id)->where('type', Markup::Type_Supplier)->where('supplier_id', $this->id)->first();
        return $supplier->data ?? [];
    }

    public function Module()
    {
        return $this->belongsTo(Module::class, 'module_id');
    }
}
