{{-- Extends layout --}}
@extends('admin.layout.default')

{{-- Content --}}
@section('content')
    <div class="container-fluid">
        <div class="row page-titles mx-0 mb-3">
            <div class="col-sm-6 p-0">
                <div class="welcome-text">
                    <h4>{{ __('Supplier') }}</h4>
                    <span>{{ __('Edit Supplier') }}</span>
                </div>
            </div>
            <div class="col-sm-6 p-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.suppliers.index') }}">{{ __('suppliers') }}</a></li>
                    <li class="breadcrumb-item active"><a href="javascript:void(0)">{{ __('Edit Supplier') }}</a></li>
                </ol>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">{{ __('Edit Supplier') }}</h4>
            </div>
            <form action="{{ route('admin.suppliers.update', $supplier->id) }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                <div class="card-body">
                    <div class="basic-form">
                        <div class="row align-items-center">
                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label>{{ __('Name') }}</label>
                                        <input type="text" name="name" id="name" class="form-control"
                                            autocomplete="name" value="{{ $supplier->name }}">
                                        @error('name')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>{{ __('Supplier key') }}</label>
                                        <input type="text" name="key" id="key" class="form-control"
                                            autocomplete="key" value="{{ $supplier->key }}">
                                        @error('key')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-6">
                                        <label>{{ __('Module') }}</label>
                                        <select name="module_id" id="module_id" class="default-select form-control">
                                            @foreach ($modules as $module)
                                                <option value="{{ $module->id }}"
                                                    {{ $supplier->module_id == $module->id ? 'selected' : '' }}>
                                                    {{ $module->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('module_id')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-6">
                                        <label>{{ __('Desc') }}</label>
                                        <input type="text" name="desc" id="desc" class="form-control"
                                            value="{{ $supplier->desc }}">
                                        @error('desc')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-12">
                                        <label>{{ __('Settings') }}</label>
                                        <div class="table-responsive">
                                            <table id="settingsTable" class="table">
                                                <thead>
                                                    <tr>
                                                        <th>{{ __('Key') }}</th>
                                                        <th>{{ __('Value') }}</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php
                                                        $settings = $supplier->settings;
                                                        $i = 0;
                                                    @endphp
                                                    @foreach ($supplier->settings as $key => $value)
                                                        <tr>
                                                            <td class="col-4">
                                                                <input type="text"
                                                                    name="settings[{{ $i }}][]"
                                                                    class="form-control" value="{{ $key }}">
                                                            </td>
                                                            <td>
                                                                <input type="text"
                                                                    name="settings[{{ $i }}][]"
                                                                    class="form-control" value="{{ $value }}">
                                                            </td>
                                                            <td>
                                                                <button class="btn btn-danger remove-setting"
                                                                    type="button">&times;</button>
                                                            </td>
                                                        </tr>
                                                        @php $i++; @endphp
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <button id="addSettingBtn" class="btn btn-xs btn-primary ms-2"
                                            type="button">{{ __('Add settings') }}</button>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">{{ __('Update') }}</button>
                    <a href="{{ route('admin.suppliers.index') }}" class="btn btn-danger">{{ __('Cancel') }}</a>
                </div>
            </form>
        </div>
    </div>
@endsection

{{-- Push required inline scripts --}}
@push('inline-scripts')
    <script>
        var i = @json($i) 
            // Add new setting row when the "Add Setting" button is clicked
            document.getElementById('addSettingBtn').addEventListener('click', function() {
                var tableBody = document.getElementById('settingsTable').getElementsByTagName('tbody')[0];
                var newRow = tableBody.insertRow();
                newRow.innerHTML = `
            <td class="col-4"><input type="text" name="settings[${i}][]" class="form-control"></td>
            <td class="col-8"><input type="text" name="settings[${i}][]" class="form-control"></td>
            <td><button class="btn btn-danger remove-setting" type="button">&times;</button></td>
        `;
                i++;
            });
        // Remove the setting row when the "Remove" button is clicked
        document.addEventListener('click', function(event) {
            if (event.target.classList.contains('remove-setting')) {
                var row = event.target.parentNode.parentNode;
                var tableBody = row.parentNode;
                // Check if there is only one row left
                if (tableBody.rows.length > 1) {
                    tableBody.removeChild(row);
                }
            }
        });
    </script>
@endpush
