<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Modules\Common\Http\Controllers\ConfigController;
use Modules\Common\Http\Controllers\LoggerController;
use Modules\Common\Http\Controllers\LogsController;
use Modules\Common\Http\Controllers\NotificationsController;
use Modules\Common\Http\Controllers\SessionController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['middleware' => ['has_permission', 'language']], function () {
    Route::group(['prefix' => 'session'], function () {
        Route::post('/check', [SessionController::class, 'check']);
    });
    Route::post('/access_token_edit', [ConfigController::class, 'access_token_edit']);
    Route::group(['prefix' => 'logs'], function () {
        Route::post('/', [LogsController::class, 'list'])->name('logs_list');
        Route::group(['prefix' => 'users'], function () {
            Route::post('/online', [LogsController::class, 'users_online'])->name('logs_users_online');
            Route::post('/tracking/{id?}', [LogsController::class, 'users_tracking'])->name('logs_users_tracking');
        });
        Route::post('/list', [LogsController::class, 'list'])->name('logs_list');
    });
    Route::group(['prefix' => 'notifications'], function () {
        Route::post('/list', [NotificationsController::class, 'list'])->name('notifications_list');
    });
});
