<?php

namespace Modules\Locales\Http\Controllers\Api\Admins;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use GuzzleHttp\Client;
use Illuminate\Support\Env;
use Modules\Locales\Entities\Currency;
use Modules\Settings\Entities\Settings;
use PHPUnit\Framework\Exception;

class CurrencyController extends Controller
{
    public function list()
    {
        $currency_list = $this->currency_list();
        return json_response($currency_list);
    }

    public function get_currencies_rates($base)
    {
        $url = 'https://open.er-api.com/v6/latest/' . $base;
        $client = $this->getClient($url);
        try {
            $response = $client->get("");
        } catch (\Throwable $th) {
            return json_response(null, 200, false, trans('web.request_failed'));
        }
        $res = json_decode($response->getBody()->getContents());
        if ($res->result == "error") {
            return json_response(null, 200, false, trans('web.request_failed'));
        }
        return $res->rates;
    }

    public function update_all()
    {
        $base_currency = 'USD';
        $currencies = $this->json_currency_list();
        $rates = $this->get_currencies_rates($base_currency);
        $currency_list = [];
        foreach ($currencies as $currency) {
            foreach ($rates as $code => $rate) {
                if ($code == $currency['code']) {
                    $currency['value'] = $rate;
                }
            }
            $currency_list[] = $currency;
        }
        foreach ($currency_list as $currency) {
            Currency::updateOrCreate(['code' => $currency['code']], $currency);
        }
        return json_response($this->currency_list(), 200, true, trans('web.updated_successfully'));
    }

    public function update(Request $req)
    {
        $changed_currencies = $req->all();
        foreach ($changed_currencies as $currency) {
            try{
                $curr = Currency::where('code', $currency['code'])->first();
                if ($curr) {
                    $updated = $curr->update(["value" => $currency['value']]);
                    if (!$updated) {
                        return json_response([], 200, false, trans('web.processing_error'));
                    }
                }
            }catch(\Exception $e){}
        }
        return json_response([], 200, true, trans('web.updated_successfully'));
    }
    public function currency_list()
    {
        $base = $this->get_base_currency();
        $currencies = Currency::all('name', 'code', 'symbol', 'value');
        $rates = $this->get_currencies_rates($base);
        $currency_list = [];
        foreach ($currencies as $currency) {
            foreach ($rates as $code => $rate) {
                if ($code == $currency['code']) {
                    $currency['new_value'] = $rate;
                }
            }
            $currency_list[] = $currency;
        }
        return [
            'base' => $base,
            'currencies' => $currency_list
        ];
    }

    //base currency
    public function get_base_currency()
    {
        $setting = Settings::where('type', 'currency')->first();
        if ($setting) {
            $base = $setting->content['base_currency'];
        } else {
            $base = env('BASE_CURRENCY', "SAR");
        }
        return $base;
    }

    public function update_base_currency($base)
    {
        if ($base) {
            Settings::UpdateOrCreate(['type' => 'currency'], [
                "content" => [
                    "base_currency" => $base
                ]
            ]);
        }
    }

    public function get_currency_data($code)
    {
        $currency = Currency::where('code', $code)->first();
        if ($currency) {
            return $currency;
        }
    }
    public function get_currency_rate($code)
    {
        $currency = Currency::where('code', $code)->first();
        if ($currency) {
            return $currency->value;
        }
    }
    // translated currencies json file
    public function json_currency_list()
    {
        $path = base_path() . '/Modules/Locales/Resources/currency/currencies.json';
        $currencies = json_decode(file_get_contents($path), true);
        return $currencies;
        // $currency_list = [];
        // set_time_limit(0);
        // foreach ($currencies as $key => $value) {
        //     $currency['code'] = $key;
        //     $currency['symbol'] = $value['symbol'];
        //     $currency['native_symbol'] = $value['symbolNative'];

        //     $currency['major']['single']['en'] = $value['majorSingle'];
        //     $currency['major']['single']['ar'] = $this->translate($value['majorSingle']);

        //     $currency['major']['Plural']['en'] = $value['majorPlural'];
        //     $currency['major']['Plural']['ar'] = $this->translate($value['majorPlural']);

        //     $currency['minor']['single']['en'] = $value['minorSingle'];
        //     $currency['minor']['single']['ar'] = $this->translate($value['minorSingle']);

        //     $currency['minor']['Plural']['en'] = $value['minorPlural'];
        //     $currency['minor']['Plural']['ar'] = $this->translate($value['minorPlural']);

        //     $currency['name']['en'] = $value['name'];
        //     $currency['name']['ar'] = $this->translate($value['name']);

        //     $currency_list[] = $currency;
        // }

        // file_put_contents($path, json_encode($currency_list));
    }

    // public function translate($text)
    // {
    //     $apiKey = 'AIzaSyDiQB3UW6Sd6VzPNJGVf4qPYgXV46t9a5s';
    //     $url = 'https://www.googleapis.com/language/translate/v2?key=' . $apiKey . '&q=' . rawurlencode($text) . '&source=en&target=ar';

    //     $client = $this->getClient($url);
    //     try {
    //         $response = $client->get("");
    //     } catch (\Throwable $th) {
    //         return json_response(null, 200, false, trans('web.request_failed'));
    //     }
    //     $translation = json_decode($response->getBody()->getContents());
    //     return $translation->data->translations[0]->translatedText;
    // }

    protected function getClient($url)
    {
        $client = new Client([
            'base_uri' => $url,
        ]);

        return $client;
    }
}
