<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Modules\Locales\Http\Controllers\Api\Admins\CurrencyController;
// use Modules\Locales\Http\Controllers\Api\Users\ContinentsController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['middleware' => ['language']], function () {
    //admins routes
    Route::group(['prefix' => 'admins/locales', 'middleware' =>  ['has_permission']], function () {
        Route::group(['prefix' => 'currencies'], function () {
            Route::get('/list/{base?}', [CurrencyController::class, 'list']);
            Route::post('/update', [CurrencyController::class, 'update']);
            Route::post('/update_all', [CurrencyController::class, 'update_all']);
            //base currency
            // Route::get('/base_currency', [CurrencyController::class, 'get_base_currency']);
            Route::post('/base_currency/{base}', [CurrencyController::class, 'update_base_currency']);
        });
    });

    //continents
    // Route::group(['prefix' => 'locales/continents'], function () {
    //     Route::get('/list', [ContinentsController::class, 'list']);
    //     Route::get('/list_countries/{continent}', [ContinentsController::class, 'list_countries']);
    // });
});
