<?php

namespace Modules\Payments\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use GuzzleHttp\Client;
use GuzzleHttp\Psr7;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Modules\Payments\Entities\Payment;
use Modules\Users\Entities\User;

class PaymentsController extends Controller
{
    public function list(Request $req, $id = null)
    {
        $company_id =  $req->get('parent');
        $user = Auth::user();
        $query = [
            'user' => function($q){
                $q->select('id', 'type', 'image', 'first_name', 'last_name', 'company');
            },
            'company' => function($q){
                $q->select('id', 'type', 'image', 'company');
            },
            'added_by' => function($q){
                $q->select('id', 'type', 'image', 'first_name', 'last_name', 'company');
            }
        ];

        if ($user->type == 'super_admin') {
            $list = Payment::with($query)->orderBy('id', 'DESC')->jsonPaginate();
        } elseif ($user->type == 'company') {
            $list = Payment::with(Arr::only($query, ['user', 'added_by']))->where('company_id', $company_id)->orderBy('id', 'DESC')->jsonPaginate();
        } else {
            $list = Payment::with(Arr::only($query, ['user', 'added_by']))->where('user_id', $user->id)->orderBy('id', 'DESC')->jsonPaginate();
        }

        return json_response_pagination($list);
    }

    public function delete($id)
    {
        $payment = Payment::findOrFail($id);
        if ($payment) {
            $payment->delete();
            return json_response([], 200, true, trans('web.deleted_successfully'));
        }
    }
}
