<?php

namespace Modules\Settings\Http\Controllers\Api;

use App\Models\Settings;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Routing\Controller;
class SettingsController extends Controller
{


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            // 'user_id' => 'required|unique:settings',
            'language' => 'required',
            'type' => 'required',
        ]);

        $data = $request->only('user-id', 'type', 'language', 'meta_title', 'meta_description', 'meta_short_url', 'meta_tags', 'meta_keywords', 'meta_head', 'slug', 'logo', 'logo_black', 'fav_icon');
        $data['content'] = json_encode($data);

        $settings = Settings::create([
            'user_id' => $request['user_id'],
            'language' => $request['language'],
            'type' => $request['type'],
            'content' => $data['content'],
        ]);
        return response()->json([
            'status'    =>  $settings ? true : false,
            'message'   =>  $settings ? 'Successfully Added' : 'Error Adding',
            'data'      =>  $settings
        ], $settings ? 200 : 404);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Settings  $settings
     * @return \Illuminate\Http\Response
     */
    public function show($type, Settings $settings)
    {
        $settings = Settings::where('type', $type)->first();
        if($settings and ! json_decode($settings->content)) {
            $settings->content = false;
        }
        return response()->json([
            'status' => $settings ? 1 : 0,
            'data'      =>  $settings ?? []
        ], 200);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Settings  $settings
     * @return \Illuminate\Http\Response
     */
    public function update($type, Request $request)
    {
        // seoupdate
        if ($type == 'seo') {
            $data = $request->only('title_en', 'title_ar', 'description_en', 'description_ar', 'keywords');
            $data = json_encode($data);
            $settings = Settings::updateOrCreate([
                'type'   => $type
            ], [
                'content' => $data
            ]);

            return response()->json([
                'status' => 'success',
                'message' => 'updated successfully',
                'data'   =>  $settings
            ], $settings ? 200 : 400);
        }
        
        else if ($type == 'credentials') {
            $data = $request->only('frontend_url','backend_url','access_token');
            $data = json_encode($data);
            $settings = Settings::updateOrCreate([
                'type'   => $type
            ], [
                'content' => $data
            ]);

            return response()->json([
                'status' => 'success',
                'message' => 'updated successfully',
                'data'   =>  $settings
            ], $settings ? 200 : 400);
        }
        else if ($type == 'social') {
            $data = $request->only('facebook','instagram','whatsapp','contactMail','phoneNumber','address_ar', 'address_en');
            $data = json_encode($data);
            $settings = Settings::updateOrCreate([
                'type'   => $type
            ], [
                'content' => $data
            ]);

            return response()->json([
                'status' => 'success',
                'message' => 'updated successfully',
                'data'   =>  $settings
            ], $settings ? 200 : 400);
        }
        else if ($type == 'logo') {
            $data = $request->only('logo_black', 'logo_white', 'favicon');
            $logoSettings = [];
            if(!empty($request->file('logo_black'))) {
                $path = url(Storage::putFile('public/logo', $request->file('logo_black'), 'public'));
                $path = str_replace('/public/', '/storage/', $path);
                $logoSettings['logo_black'] = $path;
            }
            if(!empty($request->file('logo_white'))) {
                $path = url(Storage::putFile('public/logo', $request->file('logo_white'), 'public'));
                $path = str_replace('/public/', '/storage/', $path);
                $logoSettings['logo_white'] = $path;
            }
            if(!empty($request->file('favicon'))) {
                $path = url(Storage::putFile('public/logo', $request->file('favicon'), 'public'));
                $path = str_replace('/public/', '/storage/', $path);
                $logoSettings['favicon'] = $path;
            }
            $settings = Settings::where('type', 'logo')->first();
            if($settings) {
                $logoSettings = array_merge(json_decode($settings->content, true), $logoSettings);
            }
            $logoSettings = json_encode($logoSettings);
            $settings = Settings::updateOrCreate([
                'type'   => $type
            ], [
                'content' => $logoSettings
            ]);

            return response()->json([
                'status' => 'success',
                'message' => 'updated successfully',
                'data'   =>  $settings
            ], $settings ? 200 : 400);
        }else if ($type == 'mobile') {
            $data = $request->only('mobile_icon', 'splash_screen');
            $mobile_settings = [];

            if(!empty($request->file('logo_black'))) {
                $path = url(Storage::putFile('public/logo', $request->file('splash_screen'), 'public'));
                $path = str_replace('/public/', '/storage/', $path);
                $mobile_settings['logo_black'] = $path;
            }
            if(!empty($request->file('logo_white'))) {
                $path = url(Storage::putFile('public/logo', $request->file('logo_white'), 'public'));
                $path = str_replace('/public/', '/storage/', $path);
                $mobile_settings['logo_white'] = $path;
            }
            if(!empty($request->file('favicon'))) {
                $path = url(Storage::putFile('public/logo', $request->file('favicon'), 'public'));
                $path = str_replace('/public/', '/storage/', $path);
                $mobile_settings['favicon'] = $path;
            }
            $settings = Settings::where('type', 'mobile')->first();
            if($settings) {
                $mobile_settings = array_merge(json_decode($settings->content, true), $mobile_settings);
            }
            $mobile_settings = json_encode($mobile_settings);
            $settings = Settings::updateOrCreate([
                'type'   => $type
            ], [
                'content' => $mobile_settings
            ]);

            return response()->json([
                'status' => 'success',
                'message' => 'updated successfully',
                'data'   =>  $settings
            ], $settings ? 200 : 400);
        }
        // //contactinfo update
        // if ($type == "contactinfo") {
        //     $validated = $request->validate(
        //         [
        //             'facebook' => ['regex:/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i'],
        //             'twitter' => 'url',
        //             'youtube' => 'url',
        //             'instgram' => 'url',
        //             'main_email' => 'email',
        //             'website_email' => 'email',
        //         ],
        //         [
        //             'facebook.regex' => 'invalid fortmate for facebook url'
        //         ]
        //     );

        //     $data = $request->only('type', 'language', 'facebook', 'twitter', 'youtube', 'instgram', 'main_email', 'website_email', 'mobile');
        //     $data['content'] = json_encode($data);
        //     $settings = Settings::updateOrCreate([
        //         'type'   => $request->type,
        //         'language'   => $request->language
        //     ], [
        //         'content' => $data['content']
        //     ]);

        //     return response()->json([
        //         'status' => 'success',
        //         'message' => 'updated successfully',
        //         'data'   =>  $settings
        //     ], $settings ? 200 : 404);
        // }
        // //markup update
        // if ($type == "markupInfo") {
        //     $data = $request->only('type', 'language', 'markup', 'ratio', 'amount');
        //     $data['content'] = json_encode($data);
        //     $settings = Settings::updateOrCreate([
        //         'type'   => $request->type,
        //         'language'   => $request->language
        //     ], [
        //         'content' => $data['content']
        //     ]);

        //     return response()->json([
        //         'status' => 'success',
        //         'message' => 'updated successfully',
        //         'data'   =>  $settings
        //     ], $settings ? 200 : 404);
        // }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Settings  $settings
     * @return \Illuminate\Http\Response
     */
    public function destroy(Settings $settings, $id)
    {
        $settings = Settings::where('user_id', $id)->first();
        if ($settings) {
            $settings->delete();
        }
        return response()->json([
            'status'    =>  $settings ? true : false,
            'message'   =>  $settings ? 'Successfully deleted' : 'Error deleting',
            'data'      =>  $id
        ], $settings ? 200 : 404);
    }
}
