<?php

namespace Modules\Users\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Users\Entities\Role;
use Spatie\Permission\PermissionRegistrar;
use Illuminate\Validation\Rule;

class GroupsController extends Controller
{
    //List PermissionGroups
    public function list(Request $request)
    {
        $parent_id = $request->get('parent');

        $roles = Role::where('user_id', $parent_id)->where('name', '!=', 'super_admin')->get();
        return json_response($roles);
    }

    //Create PermisisonGroup
    public function create(Request $request)
    {
        $parent_id = $request->get('parent');
        $request->validate([
            'name' => [
                Rule::unique('roles')
                  ->where('name', $request->input('name'))
                  ->where('user_id', $parent_id)
            ],
            'desc'=>'required'
        ]);
        app()[PermissionRegistrar::class]->forgetCachedPermissions();
        $role = Role::create([
            'name' => $request->name,
            'user_id' => $parent_id,
            'desc' => $request->desc,
            'guard_name' => 'sanctum',
        ]);
        return json_response($role, 200, true, trans('web.added_successfully'));
    }

    //Update PermissionGroup
    public function update(Request $request, $id)
    {
        $parent_id = $request->get('parent');
        $request->validate([
            'name' => [
                Rule::unique('roles')
                  ->where('name', $request->input('name'))
                  ->where('user_id', $parent_id)->ignore($id)
            ],
            'desc'=>'required'
        ]);
        $role = Role::find($id);
        $permissions = $request->actions;
        $request->validate([
            'name' => 'unique:roles,name,' . $id . ',id',
        ]);

        app()[PermissionRegistrar::class]->forgetCachedPermissions();
        $role->update([
            'name' => $request->name,
            'desc' => $request->desc,
            'guard_name' => 'sanctum',
        ]);
        $role->syncPermissions($permissions);

        return json_response($role, 200, true, trans('web.updated_successfully'));
    }

    //Assign Permissions To PermissionGroup
    public function assign_permissions(Request $request)
    {
        $role = Role::find($request->group_id);
        $permissions = array_merge((array) $request->actions, (array) $request->permissions);
        //assign permissions
        $role->syncPermissions($permissions);
        return json_response($role, 200, true, trans('web.assigned_successfully'));
    }

    public function permissions($id)
    {
        $role = Role::find($id);
        $actions = [];
        $permissions = [];

        foreach ($role->permissions as $row) {
            if (strpos($row['name'], '.') !== false) {
                $permissions[] = $row['name'];
            } else {
                $actions[] = $row['name'];
            }
        }

        return json_response([
            'actions' => $actions,
            'permissions' => $permissions,
        ]);
    }

    //delete PermissionGroup
    public function destroy($id)
    {
        if ($role = Role::find($id)) {
            $role->delete();
        }
        return json_response($role, 200, true, trans('web.deleted_successfully'));
    }
}
