<?php

use GuzzleHttp\Middleware;
use Illuminate\Support\Facades\Route;
use Modules\Auth\Http\Controllers\AuthController;
use Modules\Users\Http\Controllers\GroupsController;
use Modules\Users\Http\Controllers\PermissionController;
use Modules\Users\Http\Controllers\PermissionsController;
use Modules\Users\Http\Controllers\UsersController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:api')->get('/users', function (Request $request) {
//     return $request->user();
// });
Route::group(['middleware' => ['language']], function () {
    // Public routes
    Route::group(['prefix' => 'users'], function () {
        Route::post('/register', [AuthController::class, 'register']);
        Route::post('/login', [AuthController::class, 'login']);
    });

    Route::get('/modules', [AuthController::class, 'get_user_modules_with_suppliers']);

    // Authenticated routes
    Route::group(['middleware' => ['auth:sanctum', 'logger']], function () {
        Route::group(['prefix' => 'users'], function () {
            // Route::get('/check_email', [UsersController::class,'check_email']);
            // Route::get('/list', [UsersController::class,'list']);
            // Route::put('{id}/update', [UsersController::class, 'update']);
            // Route::post('add', [UsersController::class, 'add']);
            // Route::put('/{id}/permissions/update', [UsersController::class, 'updatePermissions']);
            // Route::delete('/{id}', [UsersController::class, 'delete']);

            //send token email
            Route::post('/password/email', [AuthController::class, 'sendPasswordResetLinkEmail'])->name('password.email');
            //validate token
            Route::get('/check_token/{token}/{email}', [AuthController::class, 'validateToken']);
            //change password
            Route::post('/reset_password/{token}', [AuthController::class, 'resetPassword'])->name('password.reset');
            // Verify email
            Route::post('/checksignedToken', [AuthController::class, 'checksignedToken']);
            Route::get('/verify-email/{id}/{token}', [AuthController::class, 'verifyAccount']);

            //profile
            Route::group(['prefix' => 'profile'], function () {
                Route::get('/', [AuthController::class, 'getAuthenticatedUser'])->middleware('track_online_users');
                Route::post('/update', [AuthController::class, 'update']);
                Route::post('/password/update', [AuthController::class, 'updatePassword']);
                Route::post('/image/update', [AuthController::class, 'updateImage']);
            });

            Route::group(['prefix' => 'settings'], function () {
                Route::get('/app', [AuthController::class, 'getAppSettings']);
                Route::post('/update/app', [AuthController::class, 'updateAppSettings']);
            });

            //Permissions
            Route::group(['prefix' => 'permissions', 'middleware' => 'has_permission'], function () {
                Route::get('/list/{id}', [PermissionsController::class, 'user_permissions'])->name('users_list_user_permissions');
                Route::post('/assign/{id}', [PermissionsController::class, 'give_permission_to_user']);
                Route::get('/available/{id?}', [PermissionsController::class, 'permissions'])->name('users_list_permissions');
                Route::post('/sync', [PermissionsController::class, 'SyncPermissionsFromBackOffice'])->name('users_list_sync_permissions');
                Route::post('/update/{id}', [PermissionsController::class, 'update'])->name('users_update_permission');
            });

            //Groups
            Route::group(['prefix' => 'groups', 'middleware' => 'has_permission'], function () {
                Route::get('/list', [GroupsController::class, 'list'])->name('users_list_groups');
                Route::post('/create', [GroupsController::class, 'create'])->name('users_create_groups');
                Route::post('/assign_permissions', [GroupsController::class, 'assign_permissions'])->name('users_assign_permissions_groups');
                Route::get('/permissions/{id}', [GroupsController::class, 'permissions'])->name('users_permissions_groups');
                Route::post('/update/{id}', [GroupsController::class, 'update'])->name('users_update_groups');
                Route::delete('/delete/{id}', [GroupsController::class, 'destroy'])->name('users_destroy_groups');
            });

            //users
            Route::group(['middleware' => 'has_permission'], function () {
                Route::get('/list_companies', [UsersController::class, 'list_companies'])->name('users_list_companies');
                Route::get('/list_company_employees/{company_id}', [UsersController::class, 'list_company_employees'])->name('users_list_company_employees');
                Route::get('/list_employees', [UsersController::class, 'list_employees'])->name('users_list_employees');
                Route::get('/list_companies_with_employees', [UsersController::class, 'list_companies_with_employees'])->name('users_list_companies_with_employees');
                //
                Route::post('/add_company', [UsersController::class, 'add_company'])->name('users_add_company');
                Route::post('/add_employee/{company_id?}', [UsersController::class, 'add_employee'])->name('users_add_employee');
                Route::post('/update_company/{id}', [UsersController::class, 'update_company'])->name('users_update_company');
                Route::post('/update_employee/{id}', [UsersController::class, 'update_employee'])->name('users_update_employee');
                Route::post('/update_credit_amount/{id}', [UsersController::class, 'update_credit_amount'])->name('users_update_credit_amount');
                Route::delete('/delete/{id}', [UsersController::class, 'delete'])->name('users_delete');
                // activation & deactivation
                Route::put('/activate/{id}', [UsersController::class, 'activate'])->name('users_activate');
                Route::put('/deactivate/{id}', [UsersController::class, 'deactivate'])->name('users_deactivate');

                Route::get('/user_groups/{id}', [UsersController::class, 'user_groups']);
                // Route::get('/user_groups/{id}', [UsersController::class, 'user_groups'])->name('users_user_groups');
            });
        });
    });
});