<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('logs', function (Blueprint $table) {
            $table->id();
            $table->string('method');
            $table->string('controller');
            $table->string('action');
            $table->integer('user_id');
            $table->string('user_name');
            $table->integer('company_id');
            $table->string('company_name');
            $table->longText('parameters')->nullable();
            $table->integer('response_status')->nullable();
            $table->longText('response_content')->nullable();
            $table->Text('route')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('logs');
    }
}
