<?php

namespace Modules\Common\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Log extends Model
{
    protected $table = 'logs';
    protected $fillable = ['controller', 'method','route', 'action', 'parameters', 'user_id', 'user_name', 'company_id', 'company_name', 'response_status', 'response_content'];

    protected $casts = [
        'route' => 'array',
        'parameters' => 'array',
        'response_status' => 'array',
        'response_content' => 'array',
    ];
}
