<?php

namespace Modules\Common\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Common\Entities\Session;
use Illuminate\Support\Carbon;

class SessionController extends Controller
{
    public function check(Request $request)
    {
        if($request->wowsessionkey){
            $session_time = Session::where('wowsessionkey', $request->wowsessionkey)->value('created_at');
            if($session_time){
                $time = Carbon::parse($session_time)
                ->addMinutes(20);
                $now=Carbon::now();
                if($now>$time){
                    return json_response([], 200, false,'web.session_expired');
                }
                return json_response([], 200, true, 'web.session_valid');
            }
        }
            return json_response([], 200, true, 'web.session_expired');
    }

}
