<?php

use Illuminate\Http\Request;
use Modules\Hotels\Http\Controllers\HotelsController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Http;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:api')->get('/hotels', function (Request $request) {
//     return $request->user();
// });
Route::get('/auto_complete/{query}', [HotelsController::class, 'auto_complete']);

// Route::group(['prefix' => 'hotels', 'middleware' => ['has_permission', 'logger', 'language']], function () {
Route::group(['prefix' => 'hotels', 'middleware' => ['has_permission', 'language']], function () {
    Route::get('/auto_complete/{query}', [HotelsController::class, 'auto_complete'])->name('hotels_auto_complete');
    Route::get('/search', [HotelsController::class, 'search'])->name('hotels_search');
    Route::get('/local_hotel_details/{id}', [HotelsController::class, 'local_hotel_details'])->name('hotels_local_hotel_details');
    Route::get('/available_rooms', [HotelsController::class, 'available_rooms'])->name('hotels_available_rooms');
    Route::get('/pricing', [HotelsController::class, 'pricing'])->name('hotels_pricing');
    Route::post('/booking', [HotelsController::class, 'booking'])->name('hotels_booking');
    Route::get('/booking_details/{merchant_ref}', [HotelsController::class, 'booking_details'])->name('hotels_booking_details');
    Route::get('/pre_payment/{id}', [HotelsController::class, 'pre_payment'])->name('hotels_pre_payment');
    Route::post('/invoice/{merchant_ref}', [HotelsController::class, 'invoice'])->name('hotels_invoice');
    Route::get('/payment_details/{merchant_ref}', [HotelsController::class, 'payment_details'])->name('hotels_payment_details');
    Route::get('/test', [HotelsController::class, 'test'])->name('hotels_test');
    Route::get('/local_booking_list', [HotelsController::class, 'local_booking_list'])->name('hotels_local_booking_list');
    Route::get('/remote_booking_list', [HotelsController::class, 'remote_booking_list'])->name('hotels_remote_booking_list');
    Route::get('/available_rooms_by_hotel', [HotelsController::class, 'available_rooms_by_hotel']);
    // Route::get('/pricing', [HotelsController::class, 'pricing']);
    // Route::post('/booking', [HotelsController::class, 'booking']);
    // Route::get('/booking_details/{merchant_ref}', [HotelsController::class, 'booking_details']);
    // Route::get('/pre_payment/{id}', [HotelsController::class, 'pre_payment']);
    Route::post('/invoice/{merchant_ref}', [HotelsController::class, 'invoice'])->name('hotels_invoice');
    // Route::get('/payment_details/{merchant_ref}', [HotelsController::class, 'payment_details']);
    // Route::get('/test', [HotelsController::class, 'test']);
    // Route::get('/local_booking_list', [HotelsController::class, 'local_booking_list']);
    Route::get('/cancel_booking/{merchant_ref}', [HotelsController::class, 'cancel_booking'])->name('hotels_cancel_booking');
    Route::get('/country/list', [HotelsController::class, 'country_list'])->name('hotels_country_list');
    Route::get('/nationality/list', [HotelsController::class, 'nationality_list'])->name('hotels_nationality_list');
});
