<?php

use Modules\Payments\Entities\Payment;
use Modules\Common\Entities\Session;

function check_Balance($req, $price)
{
    //b2b employee or company or company employee balance check
    if (isB2bEmployee($req) || isCompany($req) || isCompanyEmployee($req)) {
        if (get_Balance($req) >= $price) {
            return true;
        }
        return false;
    } else {
        //case b2b admin
        return true;
    }
}

function get_Balance($req)
{
    $balance = $req->user()->credit_amount + $req->user()->credit_allowed_amount;
    return $balance;
}

function update_balance($req, $price)
{
    //b2b employee balance handle
    if (isB2bEmployee($req)) {
        $employee = getUser($req);
        $employee->update(['credit_amount' => get_Balance($req) - $price]);
    }
    //company balance handle
    if (isCompany($req)) {
        $company = getUser($req);
        $company->update(['credit_amount' => get_Balance($req) - $price]);
    }
    //company employee balance handle
    if (isCompanyEmployee($req)) {
        //update employee balance
        $user = getUser($req);
        $user->update(['credit_amount' => get_Balance($req) - $price]);
        //update employee's company
        $company = getParent($req);
        $company->update(['credit_amount' => get_Balance($req) - $price]);
        //record in payment transaction
    }
}

function recordPayment($req, $merchant_ref)
{
    $user = getUser($req);
    $company = getParentId($req);
    $session = get_Session_data($req);
    $merchant_ref = explode(".", $merchant_ref);
    Payment::Create([
        'added_by' => $user->id,
        'company_id' => $company,
        'user_id' => $user->id,
        'amount' => $session->data['amount_old'],
        'module' => $merchant_ref[0],
        'supplier' => $merchant_ref[1],
        'booking_id' => (int)$merchant_ref[0],
        'currency' => $session->data['currency']??'USD',
        'type' => "debit",
    ]);
}

function update_Session($req, $res)
{
    $session = get_Session_data($req);
    if (isset($res->MerchantRef)) {
        $merchant_ref = $res->MerchantRef;
    }
    $amount = $res->data->Amount ?? $session->data['amount'];
    $currency = $res->data->Currency ?? $session->data['currency'];
    if (!empty($session)) {
        Session::updateOrCreate(['wow_session_key' => $session->wow_session_key], [
            'data' => [
                'amount' => $amount,
                'currency' => $currency,
            ],
            'merchant_ref' => $merchant_ref ?? $session->merchant_ref,
            'module' => $session->module,
            'query' => $session->query,
        ]);
    }
}

function get_Session_data($req)
{
    $session = $req->header('X-Session');
    return Session::where('wow_session_key', $session)->first();
}

function get_price($req)
{
    $session = get_Session_data($req);
    $price = $session->data['amount_old'];
    return $price;
}
// ===============================TEST==========================================

function hotel_pricing_static_response()
{

    return '{
    "status": true,
    "data": {
      "HotelWowCode": "1208646",
      "CityWowCode": "113117",
      "SupplierKey": "15",
      "ResultStatus": "01",
      "ResultIndex": "1",
      "AvailableForBook": "true",
      "AvailableForConfirmBook": "true",
      "CancellationPoliciesAvailable": "true",
      "NormsString": "CheckIn Time-Begin: 12:00 PM \n CheckIn Time-End: anytime\nCheckOut Time: 12:00 PM\nCheckIn Instructions: &lt;ul&gt;  &lt;li&gt;Extra-person charges may apply and vary depending on property policy&lt;/li&gt;&lt;li&gt;Government-issued photo identification and a cash deposit may be required at check-in for incidental charges&lt;/li&gt;&lt;li&gt;Special requests are subject to availability upon check-in and may incur additional charges; special requests cannot be guaranteed&lt;/li&gt;&lt;li&gt;Minimum Spring Break check-in age is 15 years old&lt;/li&gt;&lt;li&gt;This property only accepts cash&lt;/li&gt;&lt;li&gt;Safety features at this property include a carbon monoxide detector, a fire extinguisher, a smoke detector, a security system, a first aid kit, and window guards&lt;/li&gt;  &lt;/ul&gt; \n Special Instructions : Front desk staff will greet guests on arrival.\nMinimum CheckIn Age : 15\n Optional Fees: &lt;p&gt;The following fees and deposits are charged by the property at time of service, check-in, or check-out. &lt;/p&gt; &lt;ul&gt;      &lt;li&gt;Airport shuttle fee: EGP 300 per vehicle (one-way, maximum occupancy 4)&lt;/li&gt; &lt;li&gt;Airport shuttle fee per child: EGP 0 (one-way), (from 1 to 10 years old)&lt;/li&gt;           &lt;li&gt;Weekly housekeeping provided; fees apply for additional cleaning&lt;/li&gt;              &lt;/ul&gt; &lt;p&gt;The above list may not be comprehensive. Fees and deposits may not include tax and are subject to change. &lt;/p&gt;\nCards Accepted: Debit cards not accepted,Cash,Cash-only property\n&lt;ul&gt;  &lt;li&gt;This property offers transfers from the airport (surcharges may apply). Guests must contact the property with arrival details before travel, using the contact information on the booking confirmation. &lt;/li&gt; &lt;li&gt;Only registered guests are allowed in the guestrooms. &lt;/li&gt; &lt;li&gt;No pets and no service animals are allowed at this property. &lt;/li&gt;&lt;li&gt;This property advises that enhanced cleaning and guest safety measures are currently in place.&lt;/li&gt;&lt;li&gt;Disinfectant is used to clean the property; commonly-touched surfaces are cleaned with disinfectant between stays; bed sheets and towels are laundered at a temperature of at least 60°C/140°F; guestroom doors are sealed after cleaning; the property is cleaned and disinfected with electrostatic spray.&lt;/li&gt;&lt;li&gt;Personal protective equipment, including masks and gloves, will be available to guests.&lt;/li&gt;&lt;li&gt;Social distancing measures are in place; staff at the property wear personal protective equipment; a shield is in place between staff and guests in main contact areas; periodic temperature checks are conducted on staff; temperature checks are available to guests; guests are provided with hand sanitizer; cashless payment methods are available for all transactions; contactless room service is available; masks are required in public areas.&lt;/li&gt;&lt;li&gt;Contactless check-in and contactless check-out are available.&lt;/li&gt;&lt;li&gt;Enhanced food service safety measures are in place.&lt;/li&gt;&lt;li&gt;Individually-wrapped food options are available for breakfast.&lt;/li&gt;&lt;li&gt;Each guestroom is kept vacant for a minimum of 24 hours between bookings.&lt;/li&gt;&lt;li&gt;This property affirms that it adheres to the cleaning and disinfection practices of Safe Travels (WTTC - Global).&lt;/li&gt;\n &lt;/ul&gt;,Service animals not allowed,Pets not allowed,Gap period enforced between guest stays - 24 hours,Shield between guests and staff in main contact areas,Property follows sanitization practices of Safe Travels (WTTC - Global),Temperature checks are available to guests,Social distancing measures are in place,Guest accommodation is sealed after cleaning,Staff temperature checks are conducted regularly,Property is cleaned with disinfectant,Guests are provided with free hand sanitizer,Staff wears personal protective equipment,Cashless transactions are available,Masks are available to guests,Bed sheets and towels are washed at a temperature of at least 60°C/140°F,Food service has been amended for enhanced safety,Essential workers only - NO,Protective clothing is available to guests,Contactless check-in is available,Electrostatic spray is used for disinfection,Gloves are available to guests,Masks are compulsory at the property,No cribs (infant beds) available,No rollaway/extra beds available,Minimum guest age is 18,No elevators,Contactless check-out is available,Property confirms they are implementing guest safety measures,Contactless food service / room service is available,Individually-wrapped food options are available,Property confirms they are implementing enhanced cleaning measures,Individually-wrapped food options are available for breakfast,Cash deposit required,Commonly-touched surfaces are cleaned with disinfectant\nPlease refer to the following Terms of Use - http://mytravelagent.online/termsofuse.pdf\n\n",
      "LastCancellationDeadline": "2022-01-21T00:00:00+00:00",
      "DefaultPolicy": "Early check out will attract full cancellation charge unless otherwise specified.",
      "AutoCancellationText": "Hotel Destination Local Date and Time:21-Jan-2022 , 21:30:00",
      "CancelPolicies": [
          {
              "FromDate": "2022-01-15",
              "ToDate": "2022-01-21",
              "ChargeType": "Fixed",
              "CancellationCharge": "0",
              "Currency": "USD",
              "PrefCurrency": "SAR",
              "PrefCancellationCharge": "0"
          },
          {
              "FromDate": "2022-01-22",
              "ToDate": "2022-01-27",
              "ChargeType": "Fixed",
              "CancellationCharge": "13.75",
              "Currency": "USD",
              "PrefCurrency": "SAR",
              "PrefCancellationCharge": "50.93"
          }
      ],
      "PriceChanged": "false",
      "AvailableOnNewPrice": "false",
      "AgencyBalance": "Sufficient",
      "AgencyBlocked": "false",
      "HotelName": "Arabian Nights Hotel",
      "HotelRating": "TwoStar",
      "HotelAddress": "10 Al Aded Street off of Mansouria St.,behind Cinema Kwekib, Darassa,Cairo,EG",
      "HotelMap": {
          "Lat": "30.048528",
          "Long": ""
      },
      "RoomsGuests": [
          {
              "adults": "1",
              "children": "0",
              "children_ages": []
          }
      ],
      "HotelRooms": [
          {
              "RoomIndex": "1",
              "RoomTypeName": "Single Room, Shared Bathroom,1 Twin Bed,Nonsmoking",
              "Inclusion": "Free breakfast,Free WiFi Free breakfast",
              "RoomTypeCode": "314028539|382626889$37336^^1^^314028539|382626889|37336|141",
              "RatePlanCode": "314028539|382626889|37336|141",
              "RoomRate": {
                  "@attributes": {
                      "IsInstantConfirmed": "true",
                      "B2CRates": "false",
                      "IsPackageRate": "false",
                      "Currency": "USD",
                      "TotalFare": "233.76",
                      "AgentMarkUp": "0.00",
                      "RoomFare": "184.12",
                      "RoomTax": "49.64",
                      "PrefRoomTax": "183.85",
                      "PrefRoomFare": "681.91",
                      "PrefCurrency": "SAR",
                      "PrefPrice": "865.76"
                  },
                  "DayRates": {
                      "DayRate": [
                          {
                              "@attributes": {
                                  "Date": "2022-01-28T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-01-29T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-01-30T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-01-31T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-01T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-02T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-03T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-04T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-05T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-06T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-07T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-08T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-09T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-10T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-11T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-12T00:00:00",
                                  "BaseFare": "10.8326535294",
                                  "PrefBaseFare": "40.12"
                              }
                          },
                          {
                              "@attributes": {
                                  "Date": "2022-02-13T00:00:00",
                                  "BaseFare": "10.7926535294",
                                  "PrefBaseFare": "39.97"
                              }
                          }
                      ]
                  },
                  "ExtraGuestCharges": "0.0",
                  "ChildCharges": "0.0",
                  "Discount": "0.0",
                  "OtherCharges": "0",
                  "ServiceTax": "0.0"
              },
              "RoomPromtion": [],
              "Amenities": "Child-size slippers|Restaurant dining guide|Non-Smoking|Bedsheets provided|Television|Shower only|Local maps|Soundproofed rooms|Guidebooks or recommendations|Slippers|Minibar|Air conditioning|Daily housekeeping|Free WiFi|Phone|Room service (24 hours)|Shared bathroom|LCD TV|Free local calls|Cable TV service",
              "MealType": "BreakFast"
          }
      ],
      "TotalOriginalPrefPrice": 866,
      "TotalPrefPrice": 866,
      "PrefCurrency": "SAR"
    }
  }';
}
