<?php

use Illuminate\Http\Request;
use Modules\Payments\Http\Controllers\PaymentsController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:api')->get('/payments', function (Request $request) {
//     return $request->user();
// });

Route::group(['prefix' => 'payments','middleware'=>['has_permission','logger']], function(){
    Route::get('/transactions/list/{id?}', [PaymentsController::class,'list']);
    Route::post('/tokenize/{type}', [PaymentsController::class,'tokenize'])->name('payments_tokenize');
    Route::get('/check_payment_status/{type}', [PaymentsController::class,'check_payment_status'])->name('payments_check_payment_status');
    Route::post('/tokenize_hotels', [PaymentsController::class,'tokenize_hotels'])->name('payments_tokenize_hotels');
    Route::get('/check_hotels_payment_status', [PaymentsController::class,'check_hotels_payment_status'])->name('payments_check_hotels_payment_status');
    Route::delete('/transactions/delete/{id}', [PaymentsController::class,'delete']);
});
