<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Modules\Users\Entities\User;
use Modules\Common\Entities\Session;
use Modules\Locales\Entities\Currency;
use Modules\Settings\Entities\Settings;
use Modules\Settings\Entities\UserSettings;

function json_response($data, int $code = 200, bool $status = true, string $message = 'success')
{
    return response()->json([
        'status' => $status,
        'message' => $message,
        'data' => $data
    ], $code);
}

function json_response_pagination($data, int $code = 200, bool $status = true, string $message = 'success')
{
    $pagination = [
        'current_page' => $data->currentPage(),
        'total_pages' => $data->lastPage(),
        'total_results' => $data->total(),
        'per_page' => $data->perPage(),
        'from' => $data->firstItem(),
        'to' => $data->lastItem()
    ];
    return response()->json([
        'status' => $status,
        'message' => $message,
        'data' => $data->items(),
        'pagination' => $pagination
    ], $code);
}

function is_b2b_admin($request)
{
    $user = $request->user();
    if ($user->email == env('ADMIN_EMAIL')) {
        return true;
    }
    return false;
}

function isB2bEmployee($request)
{
    $user = $request->user();
    $parent_type = User::where('id', getParentId($request))->first()->type;
    if ($user->type == 'employee' && $parent_type == "super_admin") {
        return true;
    }
    return false;
}

function isCompany($request)
{
    $user = $request->user();
    if ($user->type == 'company') {
        return true;
    }
    return false;
}

function isCompanyEmployee($request)
{
    $user = $request->user();
    $parent_type = User::where('id', getParentId($request))->first()->type;
    if ($user->type == 'employee' && $parent_type == "company") {
        return true;
    }
    return false;
}

function getParentId($request)
{
    return $request->get('parent');
}

function getParent($request)
{
    return User::where('id', getParentId($request))->first();
}

function getUser($req)
{
    $id = $req->user()->id;
    return User::where('id', $id)->first();
}

function getCompanyId($request)
{
    $user = $request->user();
    if ($user->type == 'company') {
        return $user->id;
    }
    return false;
}

function getUserSettings()
{
    $user_id = Auth::user()->id;
    if ($user_id) {
        $setting = UserSettings::where('user_id', $user_id)->first();
        return $setting ?? null;
    }
    return null;
}

function getBaseCurrency()
{
    $currency = Settings::where('type', 'currency')->first('content')['content']['base_currency'];
    return $currency;
}

function updateCurrencyRate($amount, $currency)
{
    // $systemCurrency = 'SAR';
    $systemCurrency = getBaseCurrency();
    if ($currency == $systemCurrency) {
        return $amount;
    }

    $rate = Currency::where('code', $systemCurrency)->first();
    $amount = $rate['value'] * $amount;
    $formattedAmount = number_format($amount, 2, '.', ''); // Set thousands separator to an empty string
    return floatval($formattedAmount);
}


function createUser($user)
{
    $randomPassword = Str::random(10); // You can change the length as needed

    return User::updateOrcreate([
        'email' => $user->email
    ], [
        'first_name' => $user->first_name,
        'last_name' => $user->last_name,
        'mobile' => $user->phone,
        'password' => Hash::make($randomPassword)
    ]);
}

// function get_Session_data($req)
// {
//     $session = $req->header('X-Session');
//     if (!$session) {
//         throw new Exception('X-Session header is missing');
//     }
//     $session_data =  Session::where('key', $session)->first();
//     if (!$session_data) {
//         throw new Exception('Session Expired');
//     }
//     return $session_data;
// }
