export class Pagination {
    constructor(data) {
        this.data = data
        this.page = 1
        this.limit = 10
        this.pageCount = this.count()
        this.showsCount = 0
    }

    count(){
        return Math.ceil(this.total() / this.pageCount);
    }

    total() {
        return this.data.length
    }

    shows(){
        return this.showsCount;
    }

    hasMore() {
        return this.shows() < this.total()
    }

    next(){
        this.page++
        return this.load()
    }

    prev(){
        this.page--
        return this.load()
    }

    first(){
        this.page = 1
        this.showsCount = 0
        return this.load()
    }

    last(){
        this.page = this.pageCount
        return this.load()
    }

    load(){
        const begin = ((this.page - 1) * this.limit)
        const end = begin + this.limit
        const data = this.data.slice(begin, end)
        this.showsCount += data.length
        return data;
    }
}