const path = require('path');
const colors = require('tailwindcss/colors');
const plugin = require('tailwindcss/plugin')

module.exports = {
	content: [
		path.resolve(__dirname, './node_modules/litepie-datepicker/**/*.js'),
		'./index.html',
		'./src/**/*.{vue,js}'
	],
	darkMode: 'class', // or 'media' or 'class'
	theme: {
		extend: {
			colors: {
				
				// Change with you want it
				primary: {...colors.blue, ...{700: '#1e2c5b'}},
				secondary: colors.gray,
				'litepie-primary': colors.blue, // color system for light mode
        		'litepie-secondary': colors.gray, // color system for dark mode
				teal: colors.blue,
				orange: colors.orange
			}
		}
	},
	plugins: [
		require('@tailwindcss/forms'),
		require('@tailwindcss/line-clamp'),
		require('tailwindcss-rtl'),
x		plugin(function({ addVariant, prefix }) {
			addVariant('rtl', ({ modifySelectors, separator }) => {
				modifySelectors(({ selector }) => {
					return selectorParser((selectors) => {
						selectors.walkClasses((sel) =>{
							sel.value = `rtl${separator}${sel.value}`
							sel.parent.insertBefore(sel, selectorParser().astSync(prefix('.direction-rtl ')))
						})
					}).processSync(selector)
				})
			})
		}),
	]
};
