import { createApp } from 'vue'
import {router} from '@/plugins/router'
import {axiosConfig} from '@/plugins/axios'
import Root from '@/App.vue'
import './index.css'
import state from '@/state'
import axios from 'axios'
import clickOutside from './directive/click-outside'
import ripple from '@/directive/ripple'
import {capitalize} from '@/utils/strings'
//==============================
import jquery from 'jquery'
const jQuery = jquery;
window.jQuery = jquery;
//===============================

const app = createApp(Root);
app.use(router)
//===== directives ===================
ripple.color = {
    light: 'rgba(0, 0, 0, 0.35)',
    dark: 'rgba(255, 255, 255, 0.35)',
};
app.directive("ripple", ripple)
app.directive("click-outside", clickOutside)
app.provide('$state', state);
//===== axios ===================
axiosConfig(axios)
app.provide('$axios', axios);
//===============================
String.prototype.capitalize = function() {
    return capitalize(this)
}
//===============================
app.mount('#app')
