import store from '@/state'
const base_url = import.meta.env.VITE_BEASE_URL
export default {
    add: {
        module() {
            return base_url + '/markup/add/module'
        },
        supplier() {
            return base_url + '/markup/add/supplier'
        },
        city() {
            return base_url + '/markup/add/city'
        },
        airline() {
            return base_url + '/markup/add/airline'
        },
        airport() {
            return base_url + '/markup/add/airport'
        },
        airline_destination() {
            return base_url + '/markup/add/airline_destination'
        },
        company() {
            return base_url + '/markup/add/company'
        },
        employee() {
            return base_url + '/markup/add/employee'
        },
        hotel() {
            return base_url + '/markup/add/hotel'
        }
    },
    list: {
        modules(id) {
            if(id){
                return base_url + `/markup/company/modules/${id}`
            }else{
                return base_url + `/modules`
            }
        },
        cities() {
            return base_url + '/markup/list/city'
        },
        hotels() {
            return base_url + '/markup/list/hotel'
        },
        airlines() {
            return base_url + '/markup/list/airline'
        },
        airports() {
            return base_url + '/markup/list/airport'
        }
    },
    content: {
        countries(query) {
            return `${base_url}/markup/countries/${query}`
        },
        cities(countryCode, query) {
            return `${base_url}/markup/cities/${countryCode}/${query}`
        },
        hotels(cityCode, query) {
            return `${base_url}/markup/hotels/${cityCode}/${query}`
        },
        airlines(query) {
            return `${base_url}/markup/airlines/${query}`
        },
        airports(query) {
            return `${base_url}/markup/airports/${query}`
        },
        companies() {
            return `${base_url}/markup/companies`
        },
        employees(id) {
            if(id){
                return base_url + `/markup/employees/${id}`
            }else{
                return base_url + `/markup/employees`
            }
        }
    },
    get: {
        markup(id, type,query) {
            if(query.markup_type && query.company_id){
                return base_url + `/markup/show/${type}/${id}?markup_type=${query['markup_type']}&company_id=${query['company_id']}`
            }else{
                return base_url + `/markup/show/${type}/${id}`
            }
        }
    },
    delete: {
        city(id) {
            return `${base_url}/markup/city/${id}/delete`
        },
        hotel(id) {
            return `${base_url}/markup/hotel/${id}/delete`
        },
        airline(id) {
            return `${base_url}/markup/airline/${id}/delete`
        },
        airport(id) {
            return `${base_url}/markup/airport/${id}/delete`
        },
    }
}