function _expire(timePerMinute){
    const time = new Date();
    time.setMinutes( time.getMinutes() + timePerMinute );
    return time.getTime()
}

export function forever(key, val) {
    window.localStorage.setItem(key, JSON.stringify({
        data: val,
        expire: false
    }))
}

export function forWhile(key, val, timePerMinute) {
    window.localStorage.setItem(key, JSON.stringify({
        data: val,
        expire: _expire(timePerMinute)
    }))
}

export function forSession(key, val, timePerMinute = false) {
    window.sessionStorage.setItem(key, JSON.stringify({
        data: val,
        expire: timePerMinute == false ? timePerMinute : _expire(timePerMinute)
    }))
}

function isExpired(val){
    return val.expire && val.expire < Date.now()
}

function _has(key, type) {
    let val = window[type].getItem(key)
    if(val){
        val = JSON.parse(val)
        if(!isExpired(val)){
            return true
        }
        window[type].removeItem(key)
    }
    return false
}

export function has(key) {
    return _has(key, 'localStorage')
}

export function hasSession(key) {
    return _has(key, 'sessionStorage')
}

function _get(key, type) {
    let val =  JSON.parse(window[type].getItem(key)) || null
    if(val && val.data){
        return val.data
    }
    return val
}

export function get(key) {
    return _get(key, 'localStorage')
}

export function getSession(key) {
    return _get(key, 'sessionStorage')
}

export default{
    forever,
    forWhile,
    forSession,
    has,
    hasSession,
    get,
    getSession
}